/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.generator.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.jaxme.generator.sg.AttributeSG;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSGChain;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.PropertySG;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.TypeSGChain;
import org.apache.ws.jaxme.generator.sg.impl.TypeSGChainImpl;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.pm.generator.jdbc.CustomColumnData;
import org.apache.ws.jaxme.pm.generator.jdbc.CustomTableData;
import org.apache.ws.jaxme.pm.generator.jdbc.JaxMeJdbcSG;
import org.apache.ws.jaxme.pm.generator.jdbc.JdbcComplexTypeSG;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.Statement;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.xs.XSType;
import org.xml.sax.SAXException;

public class JdbcTypeSG
extends TypeSGChainImpl {
    private final JaxMeJdbcSG jdbcSG;
    private XSType xsType;
    static /* synthetic */ Class class$java$sql$Types;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$SQLException;
    static /* synthetic */ Class class$org$apache$ws$jaxme$PMException;
    static /* synthetic */ Class class$javax$xml$bind$JAXBException;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$xml$bind$Element;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$org$apache$ws$jaxme$Observer;
    static /* synthetic */ Class class$org$apache$ws$jaxme$PMParams;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$org$apache$ws$jaxme$pm$jdbc$PMJdbcImpl;

    protected JdbcTypeSG(JaxMeJdbcSG pJdbcSG, TypeSGChain o, XSType pType) {
        super(o);
        this.jdbcSG = pJdbcSG;
        if (pType == null) {
            throw new NullPointerException("The XSType argument must not be null.");
        }
        this.xsType = pType;
    }

    public Object newComplexTypeSG(TypeSG pController) throws SAXException {
        if (this.xsType == null) {
            throw new IllegalStateException("An instance of ComplexTypeSGChain has already been created.");
        }
        Object chain = (ComplexTypeSGChain)super.newComplexTypeSG(pController);
        chain = new JdbcComplexTypeSG(this.jdbcSG, (ComplexTypeSGChain)chain, this.xsType);
        this.xsType = null;
        return chain;
    }

    public void generate(TypeSG pController) throws SAXException {
        super.generate(pController);
        if (!pController.isComplex()) {
            return;
        }
        CustomTableData customTableData = (CustomTableData)pController.getProperty(this.jdbcSG.getKey());
        if (customTableData != null) {
            JavaQName qName = pController.getComplexTypeSG().getClassContext().getPMName();
            JavaSource js = pController.getSchema().getJavaSourceFactory().newJavaSource(qName, JavaSource.PUBLIC);
            this.getPMClass(pController, js, customTableData);
        }
    }

    public void generate(TypeSG pController, JavaSource pSource) throws SAXException {
        super.generate(pController);
        if (!pController.isComplex()) {
            return;
        }
        CustomTableData customTableData = (CustomTableData)pController.getProperty(this.jdbcSG.getKey());
        if (customTableData != null) {
            JavaQName qName = pController.getComplexTypeSG().getClassContext().getPMName();
            JavaInnerClass jic = pSource.newJavaInnerClass(qName.getClassName());
            this.getPMClass(pController, (JavaSource)jic, customTableData);
        }
    }

    protected void setPreparedStatementValue(JavaMethod pMethod, Column pColumn, Object pStmt, Object pParamNum, Object pValue, TypeSG pTypeSG) throws SAXException {
        boolean isPrimitive = pTypeSG.getSimpleTypeSG().getRuntimeType().isPrimitive();
        Column.Type type = pColumn.getType();
        if (isPrimitive) {
            if (Column.Type.BIGINT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setLong(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.BIT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setBoolean(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.DOUBLE.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setDouble(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.FLOAT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setFloat(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.INTEGER.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setInt(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.SMALLINT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setShort(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.TINYINT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setByte(", pParamNum, (Object)", ", pValue, (Object)");");
            }
        } else {
            if (!(pValue instanceof DirectAccessible)) {
                LocalJavaField v = pMethod.newJavaField(pTypeSG.getRuntimeType());
                v.addLine(pValue);
                pValue = v;
            }
            pMethod.addIf(pValue, (Object)" == null");
            pMethod.addLine(pStmt, (Object)".setNull(", pParamNum, (Object)", ", (Object)(class$java$sql$Types == null ? (class$java$sql$Types = JdbcTypeSG.class$("java.sql.Types")) : class$java$sql$Types), (Object)".", (Object)type, (Object)");");
            pMethod.addElse();
            if (Column.Type.BIGINT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setLong(", pParamNum, (Object)", ", pValue, (Object)".longValue());");
            } else if (pColumn.isBinaryColumn()) {
                pMethod.addLine(pStmt, (Object)".setBytes(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (pColumn.isStringColumn()) {
                pMethod.addLine(pStmt, (Object)".setString(", pParamNum, (Object)", ", pValue, (Object)");");
            } else if (Column.Type.DATE.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setDate(", pParamNum, (Object)", new ", (Object)(class$java$sql$Date == null ? (class$java$sql$Date = JdbcTypeSG.class$("java.sql.Date")) : class$java$sql$Date), (Object)"(", pValue, (Object)".getTime().getTime()));");
            } else if (Column.Type.DOUBLE.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setDouble(", pParamNum, (Object)", ", pValue, (Object)".doubleValue());");
            } else if (Column.Type.FLOAT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setFloat(", pParamNum, (Object)", ", pValue, (Object)".floatValue());");
            } else if (Column.Type.INTEGER.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setInt(", pParamNum, (Object)", ", pValue, (Object)".intValue());");
            } else if (Column.Type.SMALLINT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setShort(", pParamNum, (Object)", ", pValue, (Object)".shortValue());");
            } else if (Column.Type.TIME.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setTime(", pParamNum, (Object)", new ", (Object)(class$java$sql$Date == null ? (class$java$sql$Date = JdbcTypeSG.class$("java.sql.Date")) : class$java$sql$Date), (Object)"(", pValue, (Object)".getTime().getTime()));");
            } else if (Column.Type.TIMESTAMP.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setTimestamp(", pParamNum, (Object)", new ", (Object)(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JdbcTypeSG.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), (Object)"(", pValue, (Object)".getTime().getTime()));");
            } else if (Column.Type.TINYINT.equals(type)) {
                pMethod.addLine(pStmt, (Object)".setByte(", pParamNum, (Object)", ", pValue, (Object)".byteValue());");
            } else {
                throw new IllegalStateException("Unknown column type: " + type);
            }
            pMethod.addEndIf();
        }
    }

    protected Object getResultSetValue(JavaMethod pMethod, Column pColumn, Object pRs, Object pParamNum, TypeSG pTypeSG) throws SAXException {
        boolean isPrimitive = pTypeSG.getSimpleTypeSG().getRuntimeType().isPrimitive();
        Column.Type type = pColumn.getType();
        if (isPrimitive) {
            if (Column.Type.BIGINT.equals(type)) {
                return new Object[]{pRs, ".getLong(", pParamNum, ")"};
            }
            if (Column.Type.BIT.equals(type)) {
                return new Object[]{pRs, ".getBoolean(", pParamNum, ")"};
            }
            if (Column.Type.DOUBLE.equals(type)) {
                return new Object[]{pRs, ".getDouble(", pParamNum, ")"};
            }
            if (Column.Type.FLOAT.equals(type)) {
                return new Object[]{pRs, ".getFloat(", pParamNum, ")"};
            }
            if (Column.Type.INTEGER.equals(type)) {
                return new Object[]{pRs, ".getInt(", pParamNum, ")"};
            }
            if (Column.Type.SMALLINT.equals(type)) {
                return new Object[]{pRs, ".getShort(", pParamNum, ")"};
            }
            if (Column.Type.TINYINT.equals(type)) {
                return new Object[]{pRs, ".getByte(", pParamNum, ")"};
            }
            throw new IllegalStateException("Unknown primitive type: " + type);
        }
        if (pColumn.isStringColumn()) {
            return new Object[]{pRs, ".getString(", pParamNum, ")"};
        }
        if (pColumn.isBinaryColumn()) {
            return new Object[]{pRs, ".getBytes(", pParamNum, ")"};
        }
        if (Column.Type.DATE.equals(type)) {
            LocalJavaField cal = pMethod.newJavaField(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar);
            LocalJavaField date = pMethod.newJavaField(class$java$sql$Date == null ? (class$java$sql$Date = JdbcTypeSG.class$("java.sql.Date")) : class$java$sql$Date);
            date.addLine(pRs, (Object)".getDate(", pParamNum, (Object)")");
            pMethod.addIf((Object)date, (Object)" == null");
            pMethod.addLine((Object)cal, (Object)" = null;");
            pMethod.addElse();
            pMethod.addLine((Object)cal, (Object)" = ", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".getInstance();");
            pMethod.addLine((Object)cal, (Object)".setTime(", (Object)date, (Object)");");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".HOUR, 0);");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".MINUTE, 0);");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".SECOND, 0);");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".MILLISECOND, 0);");
            pMethod.addEndIf();
            return cal;
        }
        if (Column.Type.TIME.equals(type)) {
            LocalJavaField cal = pMethod.newJavaField(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar);
            LocalJavaField date = pMethod.newJavaField(class$java$sql$Time == null ? (class$java$sql$Time = JdbcTypeSG.class$("java.sql.Time")) : class$java$sql$Time);
            date.addLine(pRs, (Object)".getTime(", pParamNum, (Object)")");
            pMethod.addIf((Object)date, (Object)" == null");
            pMethod.addLine((Object)cal, (Object)" = null;");
            pMethod.addElse();
            pMethod.addLine((Object)cal, (Object)" = ", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".getInstance();");
            pMethod.addLine((Object)cal, (Object)".setTime(", (Object)date, (Object)");");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".YEAR, 0);");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".MONTH, 0);");
            pMethod.addLine((Object)cal, (Object)".set(", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".DAY_OF_MONTH, 0);");
            pMethod.addEndIf();
            return cal;
        }
        if (Column.Type.TIMESTAMP.equals(type)) {
            LocalJavaField cal = pMethod.newJavaField(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar);
            LocalJavaField date = pMethod.newJavaField(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JdbcTypeSG.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            date.addLine(pRs, (Object)".getTimestamp(", pParamNum, (Object)")");
            pMethod.addIf((Object)date, (Object)" == null");
            pMethod.addLine((Object)cal, (Object)" = null;");
            pMethod.addElse();
            pMethod.addLine((Object)cal, (Object)" = ", (Object)(class$java$util$Calendar == null ? (class$java$util$Calendar = JdbcTypeSG.class$("java.util.Calendar")) : class$java$util$Calendar), (Object)".getInstance();");
            pMethod.addLine((Object)cal, (Object)".setTime(", (Object)date, (Object)");");
            pMethod.addEndIf();
            return cal;
        }
        if (Column.Type.BIT.equals(type)) {
            LocalJavaField b = pMethod.newJavaField(Boolean.TYPE);
            b.addLine(pRs, (Object)".getBoolean(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : ", b, " ? ", class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdbcTypeSG.class$("java.lang.Boolean")) : class$java$lang$Boolean, ".TRUE : ", class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdbcTypeSG.class$("java.lang.Boolean")) : class$java$lang$Boolean, ".FALSE)"};
        }
        if (Column.Type.BIGINT.equals(type)) {
            LocalJavaField l = pMethod.newJavaField(Long.TYPE);
            l.addLine(pRs, (Object)".getLong(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : new Long(", l, ")"};
        }
        if (Column.Type.DOUBLE.equals(type)) {
            LocalJavaField d = pMethod.newJavaField(Double.TYPE);
            d.addLine(pRs, (Object)".getDouble(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : new Double(", d, ")"};
        }
        if (Column.Type.FLOAT.equals(type)) {
            LocalJavaField f = pMethod.newJavaField(Float.TYPE);
            f.addLine(pRs, (Object)".getFloat(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : new Float(", f, ")"};
        }
        if (Column.Type.INTEGER.equals(type)) {
            LocalJavaField i = pMethod.newJavaField(Integer.TYPE);
            i.addLine(pRs, (Object)".getInt(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : new Integer(", i, ")"};
        }
        if (Column.Type.SMALLINT.equals(type)) {
            LocalJavaField s = pMethod.newJavaField(Short.TYPE);
            s.addLine(pRs, (Object)".getShort(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : new Short(", s, ")"};
        }
        if (Column.Type.TINYINT.equals(type)) {
            LocalJavaField b = pMethod.newJavaField(Byte.TYPE);
            b.addLine(pRs, (Object)".getByte(", pParamNum, (Object)")");
            return new Object[]{"(", pRs, ".wasNull() ? null : new Byte(", b, ")"};
        }
        throw new IllegalStateException("Unknown column type: " + type);
    }

    protected void getFinally(JavaMethod pMethod, DirectAccessible pRessource, Object pSqlMsg, Object pJaxbMsg) {
        DirectAccessible e;
        pMethod.addLine((Object)pRessource, (Object)".close();");
        pMethod.addLine((Object)pRessource, (Object)" = null;");
        if (pSqlMsg != null) {
            e = pMethod.addCatch(class$java$sql$SQLException == null ? (class$java$sql$SQLException = JdbcTypeSG.class$("java.sql.SQLException")) : class$java$sql$SQLException);
            pMethod.addThrowNew(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException, pSqlMsg, (Object)" + ", (Object)JavaSource.getQuoted((String)": "), (Object)" + ", (Object)e, (Object)".getMessage(), ", (Object)e);
        }
        if (pJaxbMsg != null) {
            e = pMethod.addCatch(class$javax$xml$bind$JAXBException == null ? (class$javax$xml$bind$JAXBException = JdbcTypeSG.class$("javax.xml.bind.JAXBException")) : class$javax$xml$bind$JAXBException);
            pMethod.addIf((Object)e, (Object)" instanceof ", (Object)(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException));
            pMethod.addLine((Object)"throw (", (Object)(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException), (Object)") ", (Object)e, (Object)";");
            pMethod.addElse();
            pMethod.addThrowNew(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException, pSqlMsg, (Object)" + ", (Object)JavaSource.getQuoted((String)": "), (Object)" + ", (Object)e, (Object)".getMessage(), ", (Object)e);
            pMethod.addEndIf();
        }
        pMethod.addFinally();
        pMethod.addIf((Object)pRessource, (Object)" != null");
        pMethod.addTry();
        pMethod.addLine((Object)pRessource, (Object)".close();");
        pMethod.addCatch(class$java$lang$Throwable == null ? (class$java$lang$Throwable = JdbcTypeSG.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        pMethod.addEndTry();
        pMethod.addEndIf();
        pMethod.addEndTry();
    }

    /*
     * WARNING - void declaration
     */
    private int getPreparedStatementParameters(JavaMethod pMethod, Object pStmt, DirectAccessible pElement, Iterator pColumns, int pParamNum) throws SAXException {
        Iterator iter = pColumns;
        while (iter.hasNext()) {
            void var11_11;
            void var10_10;
            TypeSG typeSG;
            PropertySG propertySG;
            Column col = (Column)iter.next();
            CustomColumnData colData = (CustomColumnData)col.getCustomData();
            Object sg = colData.getSG();
            if (sg instanceof AttributeSG) {
                AttributeSG attrSG = (AttributeSG)sg;
                propertySG = attrSG.getPropertySG();
                typeSG = attrSG.getTypeSG();
            } else if (sg instanceof ParticleSG) {
                ParticleSG particleSG = (ParticleSG)sg;
                propertySG = particleSG.getPropertySG();
                typeSG = particleSG.getObjectSG().getTypeSG();
            } else {
                throw new IllegalStateException("Invalid SG type for column " + col.getName() + ": " + sg);
            }
            Object value = var10_10.getValue(pElement);
            this.setPreparedStatementValue(pMethod, col, pStmt, new Integer(++pParamNum), value, (TypeSG)var11_11);
        }
        return pParamNum;
    }

    /*
     * WARNING - void declaration
     */
    private int getResultSet(JavaMethod pMethod, DirectAccessible pRs, DirectAccessible pElement, Iterator pColumns, int pParamNum) throws SAXException {
        Iterator iter = pColumns;
        while (iter.hasNext()) {
            void var10_10;
            void var11_11;
            TypeSG typeSG;
            PropertySG propertySG;
            Column col = (Column)iter.next();
            CustomColumnData colData = (CustomColumnData)col.getCustomData();
            Object sg = colData.getSG();
            if (sg instanceof AttributeSG) {
                AttributeSG attrSG = (AttributeSG)sg;
                propertySG = attrSG.getPropertySG();
                typeSG = attrSG.getTypeSG();
            } else if (sg instanceof ParticleSG) {
                ParticleSG particleSG = (ParticleSG)sg;
                propertySG = particleSG.getPropertySG();
                typeSG = particleSG.getObjectSG().getTypeSG();
            } else {
                throw new IllegalStateException("Invalid SG type for column " + col.getName() + ": " + sg);
            }
            Object value = this.getResultSetValue(pMethod, col, pRs, new Integer(++pParamNum), (TypeSG)var11_11);
            var10_10.setValue(pMethod, pElement, value, null);
        }
        return pParamNum;
    }

    protected JavaMethod getPMClassInsertMethod(TypeSG pController, JavaSource pSource, CustomTableData pData) throws SAXException {
        JavaMethod jm = pSource.newJavaMethod("insert", JavaQNameImpl.VOID, JavaSource.PUBLIC);
        Parameter pElement = jm.addParam(class$javax$xml$bind$Element == null ? (class$javax$xml$bind$Element = JdbcTypeSG.class$("javax.xml.bind.Element")) : class$javax$xml$bind$Element, "pElement");
        jm.addThrows(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException);
        Table table = pData.getTable();
        String q = table.getSchema().getSQLFactory().newSQLGenerator().getQuery((Statement)table.getInsertStatement());
        LocalJavaField query = jm.newJavaField(class$java$lang$String == null ? (class$java$lang$String = JdbcTypeSG.class$("java.lang.String")) : class$java$lang$String);
        query.setFinal(true);
        query.addLine((Object)JavaSource.getQuoted((String)q));
        JavaQName qName = pController.getComplexTypeSG().getClassContext().getXMLInterfaceName();
        LocalJavaField elem = jm.newJavaField(qName);
        elem.addLine((Object)"(", (Object)qName, (Object)") ", (Object)pElement);
        LocalJavaField connection = jm.newJavaField(class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcTypeSG.class$("java.sql.Connection")) : class$java$sql$Connection);
        connection.addLine((Object)"null");
        jm.addTry();
        jm.addLine((Object)connection, (Object)" = getConnection();");
        LocalJavaField stmt = jm.newJavaField(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = JdbcTypeSG.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
        stmt.addLine((Object)connection, (Object)".prepareStatement(", (Object)query, (Object)")");
        jm.addTry();
        this.getPreparedStatementParameters(jm, stmt, (DirectAccessible)elem, table.getColumns(), 0);
        jm.addLine((Object)stmt, (Object)".executeUpdate();");
        this.getFinally(jm, (DirectAccessible)stmt, null, null);
        this.getFinally(jm, (DirectAccessible)connection, new Object[]{JavaSource.getQuoted((String)"Failed to execute query "), " + ", query}, null);
        return jm;
    }

    protected JavaMethod getPMClassUpdateMethod(TypeSG pController, JavaSource pSource, CustomTableData pData) throws SAXException {
        JavaMethod jm = pSource.newJavaMethod("update", JavaQNameImpl.VOID, JavaSource.PUBLIC);
        Parameter pElement = jm.addParam(class$javax$xml$bind$Element == null ? (class$javax$xml$bind$Element = JdbcTypeSG.class$("javax.xml.bind.Element")) : class$javax$xml$bind$Element, "pElement");
        jm.addThrows(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException);
        Table table = pData.getTable();
        String q = table.getSchema().getSQLFactory().newSQLGenerator().getQuery((Statement)table.getUpdateStatement());
        LocalJavaField query = jm.newJavaField(class$java$lang$String == null ? (class$java$lang$String = JdbcTypeSG.class$("java.lang.String")) : class$java$lang$String);
        query.setFinal(true);
        query.addLine((Object)JavaSource.getQuoted((String)q));
        JavaQName qName = pController.getComplexTypeSG().getClassContext().getXMLInterfaceName();
        LocalJavaField elem = jm.newJavaField(qName);
        elem.addLine((Object)"(", (Object)qName, (Object)") ", (Object)pElement);
        LocalJavaField connection = jm.newJavaField(class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcTypeSG.class$("java.sql.Connection")) : class$java$sql$Connection);
        connection.addLine((Object)"null");
        jm.addTry();
        jm.addLine((Object)connection, (Object)" = getConnection();");
        LocalJavaField stmt = jm.newJavaField(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = JdbcTypeSG.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
        stmt.addLine((Object)connection, (Object)".prepareStatement(", (Object)query, (Object)")");
        jm.addTry();
        ArrayList<Column> nonKeyColumns = new ArrayList<Column>();
        Iterator iter = table.getColumns();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            if (col.isPrimaryKeyPart()) continue;
            nonKeyColumns.add(col);
        }
        int i = 0;
        i = this.getPreparedStatementParameters(jm, stmt, (DirectAccessible)elem, nonKeyColumns.iterator(), i);
        this.getPreparedStatementParameters(jm, stmt, (DirectAccessible)elem, table.getPrimaryKey().getColumns(), i);
        jm.addLine((Object)stmt, (Object)".executeUpdate();");
        this.getFinally(jm, (DirectAccessible)stmt, null, null);
        this.getFinally(jm, (DirectAccessible)connection, new Object[]{JavaSource.getQuoted((String)"Failed to execute query "), " + ", query}, null);
        return jm;
    }

    protected JavaMethod getPMClassDeleteMethod(TypeSG pController, JavaSource pSource, CustomTableData pData) throws SAXException {
        JavaMethod jm = pSource.newJavaMethod("delete", JavaQNameImpl.VOID, JavaSource.PUBLIC);
        Parameter pElement = jm.addParam(class$javax$xml$bind$Element == null ? (class$javax$xml$bind$Element = JdbcTypeSG.class$("javax.xml.bind.Element")) : class$javax$xml$bind$Element, "pElement");
        jm.addThrows(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException);
        Table table = pData.getTable();
        JavaQName qName = pController.getComplexTypeSG().getClassContext().getXMLInterfaceName();
        LocalJavaField elem = jm.newJavaField(qName);
        elem.addLine((Object)"(", (Object)qName, (Object)") ", (Object)pElement);
        String q = table.getSchema().getSQLFactory().newSQLGenerator().getQuery((Statement)table.getDeleteStatement());
        LocalJavaField query = jm.newJavaField(class$java$lang$String == null ? (class$java$lang$String = JdbcTypeSG.class$("java.lang.String")) : class$java$lang$String);
        query.setFinal(true);
        query.addLine((Object)JavaSource.getQuoted((String)q));
        LocalJavaField connection = jm.newJavaField(class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcTypeSG.class$("java.sql.Connection")) : class$java$sql$Connection);
        connection.addLine((Object)"null");
        jm.addTry();
        jm.addLine((Object)connection, (Object)" = getConnection();");
        LocalJavaField stmt = jm.newJavaField(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = JdbcTypeSG.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
        stmt.addLine((Object)connection, (Object)".prepareStatement(", (Object)query, (Object)")");
        jm.addTry();
        this.getPreparedStatementParameters(jm, stmt, (DirectAccessible)elem, table.getPrimaryKey().getColumns(), 0);
        jm.addLine((Object)stmt, (Object)".executeUpdate();");
        this.getFinally(jm, (DirectAccessible)stmt, null, null);
        this.getFinally(jm, (DirectAccessible)connection, new Object[]{JavaSource.getQuoted((String)"Failed to execute query "), " + ", query}, null);
        return jm;
    }

    protected JavaMethod getPMClassSelectMethod(TypeSG pController, JavaSource pSource, CustomTableData pData) throws SAXException {
        JavaMethod jm = pSource.newJavaMethod("select", JavaQNameImpl.VOID, JavaSource.PUBLIC);
        Parameter pObserver = jm.addParam(class$org$apache$ws$jaxme$Observer == null ? (class$org$apache$ws$jaxme$Observer = JdbcTypeSG.class$("org.apache.ws.jaxme.Observer")) : class$org$apache$ws$jaxme$Observer, "pObserver");
        Parameter pQuery = jm.addParam(class$java$lang$String == null ? (class$java$lang$String = JdbcTypeSG.class$("java.lang.String")) : class$java$lang$String, "pQuery");
        Parameter pParams = jm.addParam(class$org$apache$ws$jaxme$PMParams == null ? (class$org$apache$ws$jaxme$PMParams = JdbcTypeSG.class$("org.apache.ws.jaxme.PMParams")) : class$org$apache$ws$jaxme$PMParams, "pParams");
        jm.addThrows(class$org$apache$ws$jaxme$PMException == null ? (class$org$apache$ws$jaxme$PMException = JdbcTypeSG.class$("org.apache.ws.jaxme.PMException")) : class$org$apache$ws$jaxme$PMException);
        Table table = pData.getTable();
        JavaQName qName = pController.getComplexTypeSG().getClassContext().getXMLInterfaceName();
        StringBuffer sb = new StringBuffer();
        Iterator iter = table.getColumns();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(col.getName().getName());
        }
        LocalJavaField query = jm.newJavaField(class$java$lang$String == null ? (class$java$lang$String = JdbcTypeSG.class$("java.lang.String")) : class$java$lang$String);
        jm.addIf((Object)pParams, (Object)" != null  &&  pParams.isDistinct()");
        jm.addLine((Object)query, (Object)" = ", (Object)JavaSource.getQuoted((String)"SELECT DISTINCT"), (Object)";");
        jm.addElse();
        jm.addLine((Object)query, (Object)" = ", (Object)JavaSource.getQuoted((String)"SELECT"), (Object)";");
        jm.addEndIf();
        jm.addLine((Object)query, (Object)" += ", (Object)JavaSource.getQuoted((String)(" " + sb + " FROM " + table.getQName())), (Object)";");
        jm.addIf((Object)pQuery, (Object)" != null");
        jm.addLine((Object)query, (Object)" += ", (Object)JavaSource.getQuoted((String)" WHERE "), (Object)" + ", (Object)pQuery, (Object)";");
        jm.addEndIf();
        LocalJavaField connection = jm.newJavaField(class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcTypeSG.class$("java.sql.Connection")) : class$java$sql$Connection);
        connection.addLine((Object)"null");
        jm.addTry();
        jm.addLine((Object)connection, (Object)" = getConnection();");
        LocalJavaField stmt = jm.newJavaField(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = JdbcTypeSG.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
        stmt.addLine((Object)connection, (Object)".prepareStatement(", (Object)query, (Object)")");
        jm.addTry();
        LocalJavaField rs = jm.newJavaField(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = JdbcTypeSG.class$("java.sql.ResultSet")) : class$java$sql$ResultSet);
        rs.addLine((Object)stmt, (Object)".executeQuery();");
        jm.addTry();
        jm.addWhile((Object)rs, (Object)".next()");
        LocalJavaField elem = jm.newJavaField(qName);
        elem.addLine((Object)"(", (Object)qName, (Object)") create()");
        this.getResultSet(jm, (DirectAccessible)rs, (DirectAccessible)elem, table.getColumns(), 0);
        jm.addLine((Object)pObserver, (Object)".notify(", (Object)elem, (Object)");");
        jm.addEndWhile();
        this.getFinally(jm, (DirectAccessible)rs, null, null);
        this.getFinally(jm, (DirectAccessible)stmt, null, null);
        Object[] sqlMsg = new Object[]{JavaSource.getQuoted((String)"Failed to execute query "), " + ", query};
        Object[] jaxbMsg = new Object[]{JavaSource.getQuoted((String)"Failed to create instance of  "), " + ", qName, ".class.getName()"};
        this.getFinally(jm, (DirectAccessible)connection, sqlMsg, jaxbMsg);
        return jm;
    }

    protected void getPMClass(TypeSG pController, JavaSource pSource, CustomTableData pTableData) throws SAXException {
        pSource.addExtends(class$org$apache$ws$jaxme$pm$jdbc$PMJdbcImpl == null ? (class$org$apache$ws$jaxme$pm$jdbc$PMJdbcImpl = JdbcTypeSG.class$("org.apache.ws.jaxme.pm.jdbc.PMJdbcImpl")) : class$org$apache$ws$jaxme$pm$jdbc$PMJdbcImpl);
        this.getPMClassInsertMethod(pController, pSource, pTableData);
        this.getPMClassUpdateMethod(pController, pSource, pTableData);
        this.getPMClassDeleteMethod(pController, pSource, pTableData);
        this.getPMClassSelectMethod(pController, pSource, pTableData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

