/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.ino;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Element;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ws.jaxme.JMHandler;
import org.apache.ws.jaxme.JMManager;
import org.apache.ws.jaxme.JMUnmarshaller;
import org.apache.ws.jaxme.Observer;
import org.apache.ws.jaxme.PMException;
import org.apache.ws.jaxme.PMParams;
import org.apache.ws.jaxme.pm.impl.PMIdImpl;
import org.apache.ws.jaxme.pm.ino.InoResponseHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class InoManager
extends PMIdImpl {
    private URL dbURL;
    private String user;
    private String password;
    private String idTag;
    private String elementTag;
    private boolean useGet;
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();

    public String getElementTag() {
        return this.elementTag;
    }

    public void setElementTag(String pElementTag) {
        this.elementTag = pElementTag;
    }

    public String getIdTag() {
        return this.idTag;
    }

    public void setIdTag(String pIdTag) {
        this.idTag = pIdTag;
    }

    public void init(JMManager pManager) throws JAXBException {
        super.init(pManager);
        this.idTag = pManager.getProperty("ino.idTag");
        if (this.idTag == null || this.idTag.length() == 0) {
            throw new JAXBException("Missing property: 'ino.idTag' (Tag name or attribute name of the element ID)");
        }
        this.elementTag = pManager.getProperty("ino.elementTag");
        if (this.elementTag == null || this.elementTag.length() == 0) {
            throw new JAXBException("Missing property: 'ino.elementTag' (Qualified element name, including namespace prefix)");
        }
        String url = pManager.getProperty("ino.url");
        if (url == null || url.length() == 0) {
            throw new JAXBException("Missing property: 'ino.url' (Tamino database URL)");
        }
        this.user = pManager.getProperty("ino.user");
        this.password = pManager.getProperty("ino.password");
        this.useGet = Boolean.valueOf(pManager.getProperty("ino.useGet"));
    }

    protected String getDeleteQuery(Element pElement) throws JAXBException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        String id = this.getId(pElement);
        if (id == null || id.length() == 0) {
            throw new JAXBException("The element being deleted doesn't have an ID.");
        }
        return "_delete=" + URLEncoder.encode(this.getElementTag() + '[' + this.getIdTag() + '=' + id + ']');
    }

    protected String getUpdateQuery(Element pElement) throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = this.getManager().getFactory().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.marshal((Object)pElement, (Writer)sw);
        return "_process=" + URLEncoder.encode(sw.toString());
    }

    protected String getInsertQuery(Element pElement) throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = this.getManager().getFactory().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.marshal((Object)pElement, (Writer)sw);
        return "_process=" + URLEncoder.encode(sw.toString());
    }

    protected HttpURLConnection getResponse(String pQuery) throws SAXException {
        URL connectionURL = this.dbURL;
        try {
            if (this.useGet) {
                String dburl = connectionURL.toString();
                String url = dburl.indexOf(63) > 0 ? dburl + "&" + pQuery : dburl + "?" + pQuery;
                try {
                    connectionURL = new URL(url);
                    HttpURLConnection conn = (HttpURLConnection)connectionURL.openConnection();
                    conn.setDoOutput(false);
                    conn.setDoInput(true);
                    return conn;
                }
                catch (MalformedURLException e) {
                    throw new SAXException("Malformed database URL: " + url);
                }
            }
            HttpURLConnection conn = (HttpURLConnection)connectionURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStream ostream = conn.getOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(ostream);
            w.write(pQuery);
            ((Writer)w).close();
            return conn;
        }
        catch (IOException e) {
            throw new SAXException("I/O Error: " + e.getMessage(), e);
        }
    }

    protected InoResponseHandler performQuery(String pQuery, List pList) throws SAXException {
        InoResponseHandler irh = new InoResponseHandler();
        if (pList != null) {
            irh.setInoObjectIdList(pList);
        }
        this.performQuery(pQuery, irh);
        return irh;
    }

    protected void performQuery(String pQuery, InoResponseHandler pHandler) throws SAXException {
        HttpURLConnection conn = this.getResponse(pQuery);
        try {
            InputSource isource = new InputSource(conn.getInputStream());
            isource.setEncoding(conn.getContentEncoding());
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler(pHandler);
            xr.parse(isource);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("ParserConfigurationException: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SAXException("I/O Exception: " + e.getMessage(), e);
        }
    }

    public void select(Observer pObserver, String pQuery, PMParams pPlaceHolderArgs) throws PMException {
        pQuery = super.parseQuery(pQuery, pPlaceHolderArgs);
        int max = pPlaceHolderArgs.getMaxResultDocuments();
        int skip = pPlaceHolderArgs.getSkippedResultDocuments();
        String q = max != 0 || skip != 0 ? "_xql(" + (skip + 1) + "," + max + ")=" : "_xql=";
        q = q + URLEncoder.encode(pQuery);
        InoResponseHandler irh = new InoResponseHandler();
        Class c = this.getManager().getHandlerClass();
        try {
            JMHandler handler = (JMHandler)c.newInstance();
            handler.init((JMUnmarshaller)null);
            handler.setObserver(pObserver);
            irh.setResultHandler((ContentHandler)handler);
            this.performQuery(q, irh);
        }
        catch (InstantiationException e) {
            throw new PMException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PMException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PMException((Throwable)e);
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }

    public void insert(Element pElement) throws PMException {
        try {
            String query = this.getInsertQuery(pElement);
            ArrayList idList = new ArrayList();
            this.performQuery(query, idList);
            if (idList.size() == 0) {
                throw new PMException("Query did not return an ino:id");
            }
        }
        catch (SAXException e) {
            throw new PMException((Throwable)e);
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }

    public void update(Element pElement) throws PMException {
        try {
            String query = this.getUpdateQuery(pElement);
            this.performQuery(query, (List)null);
        }
        catch (SAXException e) {
            throw new PMException((Throwable)e);
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }

    public void delete(Element pElement) throws PMException {
        try {
            String query = this.getDeleteQuery(pElement);
            this.performQuery(query, (List)null);
        }
        catch (NoSuchMethodException e) {
            throw new PMException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PMException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PMException(e.getTargetException());
        }
        catch (SAXException e) {
            throw new PMException((Throwable)e);
        }
        catch (JAXBException e) {
            if (e instanceof PMException) {
                throw (PMException)e;
            }
            throw new PMException((Throwable)e);
        }
    }

    static {
        spf.setNamespaceAware(true);
        spf.setValidating(false);
    }
}

