/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.List;
import javax.el.ExpressionFactory;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.shared_impl.util.StateUtils;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;
import org.apache.myfaces.webapp.FacesInitializer;

public abstract class AbstractFacesInitializer
implements FacesInitializer {
    private static final Log log = LogFactory.getLog(AbstractFacesInitializer.class);
    protected static final String EXPRESSION_FACTORY = "org.apache.myfaces.EXPRESSION_FACTORY";

    public void initFaces(ServletContext servletContext) {
        try {
            ServletExternalContextImpl externalContext;
            WebXml webXml;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Initializing MyFaces");
            }
            if ((webXml = WebXml.getWebXml(externalContext = new ServletExternalContextImpl(servletContext, null, null))) == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Couldn't find the web.xml configuration file. Abort initializing MyFaces.");
                }
                return;
            }
            if (webXml.getFacesServletMappings().isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No mappings of FacesServlet found. Abort initializing MyFaces.");
                }
                return;
            }
            this.initContainerIntegration(servletContext, externalContext);
            String useEncryption = servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION");
            if (!"false".equals(useEncryption)) {
                StateUtils.initSecret(servletContext);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("ServletContext '" + servletContext.getRealPath("/") + "' initialized."));
            }
        }
        catch (Exception ex) {
            log.error((Object)("An error occured while initializing MyFaces: " + ex.getMessage()), (Throwable)ex);
        }
    }

    public void destroyFaces(ServletContext servletContext) {
    }

    protected RuntimeConfig buildConfiguration(ServletContext servletContext, ExternalContext externalContext, ExpressionFactory expressionFactory) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        runtimeConfig.setExpressionFactory(expressionFactory);
        ApplicationImpl.setInitializingRuntimeConfig(runtimeConfig);
        new FacesConfigurator(externalContext).configure();
        this.validateFacesConfig(servletContext, externalContext);
        return runtimeConfig;
    }

    protected void validateFacesConfig(ServletContext servletContext, ExternalContext externalContext) {
        String validate = servletContext.getInitParameter("org.apache.myfaces.VALIDATE");
        if ("true".equals(validate) && log.isWarnEnabled()) {
            List<String> warnings = FacesConfigValidator.validate(externalContext, servletContext.getRealPath("/"));
            for (String warning : warnings) {
                log.warn((Object)warning);
            }
        }
    }

    protected static ExpressionFactory getUserDefinedExpressionFactory(ExternalContext externalContext) {
        String expressionFactoryClassName = externalContext.getInitParameter(EXPRESSION_FACTORY);
        if (expressionFactoryClassName != null && expressionFactoryClassName.trim().length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to load the ExpressionFactory implementation you've specified: '" + expressionFactoryClassName + "'."));
            }
            return AbstractFacesInitializer.loadExpressionFactory(expressionFactoryClassName);
        }
        return null;
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName) {
        try {
            Class<?> expressionFactoryClass = Class.forName(expressionFactoryClassName);
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("An error occured while instantiating a new ExpressionFactory. Attempted to load class '" + expressionFactoryClassName + "'."), (Throwable)ex);
            }
            return null;
        }
    }

    protected abstract void initContainerIntegration(ServletContext var1, ExternalContext var2);
}

