/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.smb.SmbFileRandomAccessContent;
import org.apache.commons.vfs.provider.smb.SmbFileSystem;
import org.apache.commons.vfs.util.RandomAccessMode;

class SmbFileObject
extends AbstractFileObject
implements FileObject {
    private final String fileName;
    private SmbFile file;

    protected SmbFileObject(FileName name, SmbFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileName = name.getURI();
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.createSmbFile(this.fileName);
        }
    }

    protected void doDetach() throws Exception {
        this.file = null;
    }

    private SmbFile createSmbFile(String path) throws MalformedURLException, SmbException {
        SmbFile f = new SmbFile(path);
        return this.createSmbFile(f);
    }

    private SmbFile createSmbFile(SmbFile file) throws MalformedURLException, SmbException {
        if (file.isDirectory() && !file.toString().endsWith("/")) {
            String listDirPath = file.toString() + "/";
            file = new SmbFile(listDirPath);
        }
        return file;
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        return this.file.list();
    }

    protected boolean doIsHidden() throws Exception {
        return this.file.isHidden();
    }

    protected void doDelete() throws Exception {
        this.file.delete();
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.file.renameTo(this.createSmbFile(newfile.getName().getURI()));
    }

    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
        this.file = this.createSmbFile(this.file);
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getLastModified();
    }

    protected InputStream doGetInputStream() throws Exception {
        return new SmbFileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new SmbFileOutputStream(this.file, bAppend);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SmbFileRandomAccessContent(this.file, mode);
    }
}

