package com.alan.alansdk;

import androidx.annotation.NonNull;

import com.alan.alansdk.events.EventCommand;
import com.alan.alansdk.events.EventOptions;
import com.alan.alansdk.events.EventParsed;
import com.alan.alansdk.events.EventRecognised;
import com.alan.alansdk.events.EventText;

abstract public class AlanCallback {

    /**
     * Invokes on button state changed
     * @param alanState
     *
     * * @deprecated use {@link #onButtonState()} instead.
     */
    @Deprecated
    public void onAlanStateChanged(final @NonNull AlanState alanState) {

    }

    /**
     * Invokes on button state changed
     * @param alanState
     */

    public void onButtonState(final @NonNull AlanState alanState) {

    }

    /**
     * Invokes when user speech is recognized on backend
     * @param eventRecognised
     *
     * @deprecated use {@link #onEvent()} instead.
     */
    @Deprecated
    public void onRecognizedEvent(final EventRecognised eventRecognised) {

    }

    /**
     * Invokes when user speech is parsed on backend
     * @param eventParsed
     *
     * @deprecated use {@link #onEvent()} instead.
     */
    @Deprecated
    public void onParsedEvent(EventParsed eventParsed) {

    }

    public void onOptionsReceived(final EventOptions eventOptions) {

    }

    /**
     * Invokes when some command from the script side is received
     * @param eventCommand
     *
     * @deprecated use {@link #onCommand()} instead.
     */
    @Deprecated
    public void onCommandReceived(final EventCommand eventCommand) {

    }

    /**
     * Invokes when some command from the script side is received
     * @param eventCommand
     */
    public void onCommand(final EventCommand eventCommand) {

    }

    /**
     * Invokes on answer from the script
     * @param eventText
     *
     * @deprecated use {@link #onEvent()} instead.
     */
    @Deprecated
    public void onTextEvent(final EventText eventText) {

    }

    /**
     * Invokes event
     * @param event
     * @param payload
     *
     * @deprecated use {@link #onEvent()} instead.
     */
    @Deprecated
    public void onEvent(final String event, final String payload) {

    }

    /**
     * Invokes event
     * @param payload
     */
    public void onEvent(final String payload) {

    }

    public void onError(final String error) {

    }
}
