package com.alan.alansdk.alanbase;

import android.content.Context;
import android.media.AudioManager;

import com.alan.alansdk.logging.AlanLogger;

public class AudioConfig {
    public static int SAMPLE_RATE = 44100;

    public final static int SKIP_MILLIS_ON_START = 430;

    public static void determineSupportedSampleRate(Context context) {
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        String rate = audioManager.getProperty(AudioManager.PROPERTY_OUTPUT_SAMPLE_RATE);
        String size = audioManager.getProperty(AudioManager.PROPERTY_OUTPUT_FRAMES_PER_BUFFER);
        AlanLogger.d("Buffer Size and sample rate\nSize :" + size + " & Rate: " + rate);

        try {
            SAMPLE_RATE = Integer.parseInt(rate);
        } catch (NumberFormatException e) {
            AlanLogger.e(e);
            SAMPLE_RATE = 44100;
        }
    }
}
