package com.alan.alansdk.button;

import android.content.Context;

import com.alan.alansdk.events.EventOptions;

public class ColorManager {

    private static EventOptions.AlanColor DEFAULT_CONNECTING_COLOR = new EventOptions.AlanColor(
            "#1eb6e5", "#1995ff"
    );
    private static EventOptions.AlanColor DEFAULT_IDLE_COLOR = new EventOptions.AlanColor(
            "#1eb6e5", "#1995ff"
    );
    private static EventOptions.AlanColor DEFAULT_LISTEN_COLOR = new EventOptions.AlanColor(
            "#0046ff", "#009cff"
    );
    private static EventOptions.AlanColor DEFAULT_PROCESS_COLOR = new EventOptions.AlanColor(
            "#00ffcd", "#0073ff"
    );
    private static EventOptions.AlanColor DEFAULT_REPLY_COLOR = new EventOptions.AlanColor(
            "#7a28ff", "#3d7aff"
    );
    private static EventOptions.AlanColor DEFAULT_DISCONNECTED_COLOR = new EventOptions.AlanColor(
            "#4e627e", "#5b7491"
    );

    private EventOptions.AlanColor connectingColor = DEFAULT_CONNECTING_COLOR;
    private EventOptions.AlanColor idleColor = DEFAULT_IDLE_COLOR;
    private EventOptions.AlanColor listenColor = DEFAULT_LISTEN_COLOR;
    private EventOptions.AlanColor processColor = DEFAULT_PROCESS_COLOR;
    private EventOptions.AlanColor replyColor = DEFAULT_REPLY_COLOR;
    private EventOptions.AlanColor disconnectedColor = DEFAULT_DISCONNECTED_COLOR;

    public ColorManager(Context context) {
    }

    public EventOptions.AlanColor getDisconnectedColor() {
        return disconnectedColor;
    }

    public EventOptions.AlanColor getIdleColor() {
        return idleColor;
    }

    public EventOptions.AlanColor getConnectingColor() {
        return connectingColor;
    }

    public EventOptions.AlanColor getProcessColor() {
        return processColor;
    }

    public EventOptions.AlanColor getListenColor() {
        return listenColor;
    }

    public EventOptions.AlanColor getReplyColor() {
        return replyColor;
    }

    public void setIdleColor(EventOptions.AlanColor idleColor) {
        if (idleColor != null) {
            this.idleColor = idleColor;
        } else {
            this.idleColor = DEFAULT_IDLE_COLOR;
        }
    }

    public void setConnectingColor(EventOptions.AlanColor idleColor) {
        if (idleColor != null) {
            this.idleColor = idleColor;
        } else {
            this.idleColor = DEFAULT_IDLE_COLOR;
        }
    }

    public void setListenColor(EventOptions.AlanColor listenColor) {
        if (listenColor != null) {
            this.listenColor = listenColor;
        } else {
            this.listenColor = DEFAULT_LISTEN_COLOR;
        }
    }

    public void setProcessColor(EventOptions.AlanColor processColor) {
        if (processColor != null) {
            this.processColor = processColor;
        } else {
            this.processColor = DEFAULT_PROCESS_COLOR;
        }
    }

    public void setReplyColor(EventOptions.AlanColor replyColor) {
        if (replyColor != null) {
            this.replyColor = replyColor;
        } else {
            this.replyColor = DEFAULT_REPLY_COLOR;
        }
    }

}
