package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

import com.alan.alansdk.button.GradientButton;

public class BackgroundAnimation extends BaseAnimation {

    public enum STATE {
        NORMAL,
        RESPONDING;
    }

    private GradientButton bgView;

    private final static long NORMAL_TIME = 12000;//ms
    private final static long RESPONDING_TIME = 6000;//ms

    private STATE state = STATE.NORMAL;

    public BackgroundAnimation(GradientButton bg) {
        this.bgView = bg;
    }

    public void setState(STATE state) {
        this.state = state;
        stopAnimation();
        anim = null; //force animation recreate
    }

    public void startNormalAnimation() {
        setState(STATE.NORMAL);
        startAnimation();
    }

    public void startRespondingAnimation() {
        setState(STATE.RESPONDING);
        startAnimation();
    }

    @Override
    protected AnimatorSet buildAnimator() {
        anim = new AnimatorSet();

        if (state == STATE.NORMAL) {
            ObjectAnimator bgAnimation = getAnimation(bgView, NORMAL_TIME);
            anim.play(bgAnimation);
        } else {
            ObjectAnimator bgAnimation = getAnimation(bgView, RESPONDING_TIME);
            ObjectAnimator bgScaleXAnimation = getScaleAnimation(bgView, "scaleX");
            ObjectAnimator bgScaleYAnimation = getScaleAnimation(bgView, "scaleY");
            anim.playTogether(bgAnimation,
                    bgScaleXAnimation,
                    bgScaleYAnimation);
        }
        return anim;
    }

    private ObjectAnimator getScaleAnimation(View view, String property) {

        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                property,
                1.0f, 1.10f);

        animation.setDuration(AnimationConfig.BACKGROUND_SCALE_ANIMATION_TIME);
        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(ValueAnimator.INFINITE);
        animation.setRepeatMode(ValueAnimator.REVERSE);
        return animation;
    }

    private ObjectAnimator getAnimation(View view, long time) {
        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                "rotation",
                0.0f, 360.0f);

        animation.setDuration(time);
        animation.setRepeatCount(ValueAnimator.INFINITE);
//        animation.setRepeatMode(ValueAnimator.REVERSE);
        return animation;
    }

    @Override
    public void stopAnimation() {
        super.stopAnimation();
        bgView.setScaleX(1.0f);
        bgView.setScaleY(1.0f);
    }
}
