package com.alan.alansdk.prefs;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.view.View;
import android.widget.ImageView;

import com.alan.alansdk.Utils;
import com.alan.alansdk.logging.AlanLogger;
import com.alan.alansdk.prefs.FileCache;
import com.alan.alansdk.prefs.BitmapCircleMask;

import java.io.InputStream;

public class DownloadImageTask extends AsyncTask<String, Void, Bitmap> {
    ImageView bmImage;

    public DownloadImageTask(ImageView bmImage) {
        this.bmImage = bmImage;
    }

    protected Bitmap doInBackground(String... urls) {
        String urldisplay = urls[0];
        Bitmap mIcon11 = null;

        try {
            InputStream in = new java.net.URL(urldisplay).openStream();
            mIcon11 = BitmapFactory.decodeStream(in);
        } catch (Exception e) {
            AlanLogger.e("Error" + e.getMessage());
            e.printStackTrace();
        }
        if (mIcon11 != null) {
            FileCache.getInstance().saveBitmapToCache(Utils.getActivityFromView(bmImage), urldisplay, mIcon11);
        }
        return mIcon11;
    }

    protected void onPostExecute(Bitmap result) {
        Bitmap circleBitmap = BitmapCircleMask.GetBitmapClippedCircle(result);
        bmImage.setImageBitmap(circleBitmap);
    }
}