package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class PopupAlphaAnimation {

    final private View popup;

    public PopupAlphaAnimation(View popupView) {
        this.popup = popupView;
    }

    public void animate(float newAlpha) {
        AnimatorSet anim = new AnimatorSet();
        ObjectAnimator setAlphaAnimation = getAlphaAnimation(popup, newAlpha);
        anim.play(setAlphaAnimation);
        anim.start();
    }

    private ObjectAnimator getAlphaAnimation(View view, float target) {
        ObjectAnimator animation = ObjectAnimator.ofFloat(view, "alpha", view.getAlpha(), target);
        animation.setDuration(AnimationConfig.POPUP_ALPHA_ANIMATION_TIME);
        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}
