package com.alan.alansdk.events;

import android.graphics.Color;
import android.os.Build;

import androidx.annotation.Nullable;

import com.alan.alansdk.Utils;
import com.alan.alansdk.prefs.AlanPrefs;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class EventOptions implements Serializable {

    public static final String EVENT_NAME = "options";

    @SerializedName("projectName")
    public String projectName;
    @SerializedName("android")
    private AndroidSettings androidSettings;

    public static EventOptions fromJson(String json) {
        Gson gson = new Gson();
        return gson.fromJson(json, EventOptions.class);
    }

    public AndroidSettings getAndroidSettings() {
        if (androidSettings == null) {
            return new AndroidSettings();
        } else {
            return androidSettings;
        }
    }

    public static class ButtonColor implements Serializable {
        @SerializedName("background")
        public AlanColor background;
        @SerializedName("shadow")
        public AlanColor shadow;
    }

    public static class AlanColor implements Serializable {
        @SerializedName("angle")
        public int angle;
        @SerializedName("color")
        public List<String> colorList;

        public int getFirstColor() {
            if (colorList.size() > 0) {
                return Color.parseColor(colorList.get(0));
            } else {
                return Color.BLUE;
            }
        }

        public int getSecondColor() {
            if (colorList.size() > 1) {
                return Color.parseColor(colorList.get(1));
            } else {
                return Color.BLUE;
            }
        }

        public AlanColor() {}

        public AlanColor(String color1, String color2) {
            angle = 45;
            colorList = Arrays.asList(color1, color2);
        }
    }

    public static class AndroidSettings implements Serializable {

        @SerializedName("hidden")
        public boolean isButtonHidden = false;
        @SerializedName("btnOptions")
        public ButtonOptions buttonOptions;
        @SerializedName("buttonSize")
        public int buttonSize;
        @SerializedName("alanWakeWord")
        public WakewordOptions wakewordOptions;

        @SerializedName("qrCode")
        public QROptions qrOptions;
        @Nullable
        @SerializedName("selectedBtnOptionId")
        public String btnOptionId;
        @Nullable
        @SerializedName("timeout")
        private Long timeout;
        @SerializedName("hideS2TPanel")
        private boolean hideS2TPanel = false;
        @SerializedName("screenshotEnabled")
        private boolean screenShotsEnabled;
        @SerializedName("keepMicrophoneInBackground")
        public boolean keepMicrophoneInBackground;
        @Nullable
        @SerializedName("logoUrl")
        public String logoUrl;
        @Nullable
        @SerializedName("logoIdle")
        public String logoIdle;
        @Nullable
        @SerializedName("logoListen")
        public String logoListen;
        @Nullable
        @SerializedName("logoProcess")
        public String logoProcess;
        @Nullable
        @SerializedName("logoReply")
        public String logoReply;

        public boolean isScreenShotsEnabled() {
            return screenShotsEnabled;
        }

        public Boolean isQREnabled() {
            if (qrOptions != null) {
                return qrOptions.isQREnabled;
            }
            return false;
        }
        public Boolean isWakeWordEnabled() {
            if (Build.VERSION.SDK_INT == Build.VERSION_CODES.N || Build.VERSION.SDK_INT == Build.VERSION_CODES.N_MR1){
                return false;
            } else if (wakewordOptions != null) {
                return wakewordOptions.isWakeWordEnabled;
            }
            return false;
        }

        public Boolean isWakeWordInBackgroundEnabled() {
            if (Build.VERSION.SDK_INT == Build.VERSION_CODES.N || Build.VERSION.SDK_INT == Build.VERSION_CODES.N_MR1){
                return false;
            } else if (wakewordOptions != null) {
                return wakewordOptions.wakeWordInBackground;
            }
            return false;
        }

        public String getWakeWordModelUrl() {
            if (Build.VERSION.SDK_INT == Build.VERSION_CODES.N || Build.VERSION.SDK_INT == Build.VERSION_CODES.N_MR1){
                return "";
            } else if (wakewordOptions != null) {
                WakewordModel3Options wakewordModel3Options = wakewordOptions.wakeWordModel3;
                if (wakewordModel3Options != null) {
                    return wakewordModel3Options.modelUrl;
                }
            }
            return "";
        }

        public Long getTimeout() {
            if (timeout == null) {
                return AlanPrefs.DEFAULT_TIMEOUT;
            } else {
                return timeout;
            }
        }

        public boolean shouldHideS2TPanel() {
            return hideS2TPanel;
        }

        public static class ButtonOptions implements Serializable {
            @SerializedName("idle")
            public ButtonColor idleColor;
            @SerializedName("listen")
            public ButtonColor listenColor;
            @SerializedName("process")
            public ButtonColor processColor;
            @SerializedName("reply")
            public ButtonColor replyColor;
        }

        public static class WakewordModel3Options implements Serializable {
            @SerializedName("modelUrl")
            public String modelUrl = "";
        }

        public static class QROptions implements Serializable {
            @SerializedName("enabled")
            public boolean isQREnabled;
        }
        public static class WakewordOptions implements Serializable {
            @SerializedName("wakeWordEnabled")
            public boolean isWakeWordEnabled;
            @SerializedName("wakeWordInBackground")
            public boolean wakeWordInBackground;
            @SerializedName("wakeWordPath")
            public String wakeWordPath = "";
            @SerializedName("wakeWordModel3")
            public WakewordModel3Options wakeWordModel3;
        }
    }
}
