package com.alan.alansdk.events;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

public class EventParsed {

    public static class ParsedEntity {
        @SerializedName("index")
        public int index;
        @SerializedName("type")
        public String type;
        @SerializedName("value")
        public String value;
    }

    public static final String EVENT_NAME = "parsed";

    /**
     *  {"context":14,"dist":0.08197999000549316,
     *  "ents":[{"index":8,"type":"ITEM","value":"Stella sunglasses"}],
     *  "notFound":false,"pLoc":{"file":"Logic","line":234},
     *  "pattern":"and stella sunglasses",
     *  "reqId":"1560341268290/1","text":"and one Stella sunglasses"}
     */

    @SerializedName("text")
    private String text;
    @SerializedName("ents")
    private List<ParsedEntity> entities;
    @SerializedName("reqId")
    public String reqId;

    public String getText() {
        return text;
    }

    public List<ParsedEntity> getEntities() {
        return entities;
    }

    public EventParsed(String text) {
        this.text = text;
        this.entities = new ArrayList<>();
    }

    public static EventParsed fromJson(String json) {
        Gson gson = new Gson();
        return gson.fromJson(json, EventParsed.class);
    }
}
