package com.alan.alansdk.prefs;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.alan.alansdk.logging.AlanLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileCache {

    private static FileCache instance;

    static final String CACHE_FOLDER = "cached_images";

    private FileCache() { }

    public static FileCache getInstance() {
        if (instance == null) {
            instance = new FileCache();
        }
        return instance;
    }

    public void saveBitmapToCache(Context context, String key, Bitmap bitmap){
        String fileName = String.valueOf(key.hashCode());
        writeToFile(context, bitmapToStream(bitmap), fileName);
    }

    public Bitmap retrieveBitmapFromCache(Context context, String key){
        String fileName = String.valueOf(key.hashCode());
        return readFromFile(context, fileName);
    }

    private ByteArrayOutputStream bitmapToStream(Bitmap bitmap) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, os);
        return os;
    }

    private Bitmap readFromFile(Context context, String fileName) {
        File folder = new File(context.getFilesDir(), CACHE_FOLDER);
        File fn = new File(folder, fileName);
        FileInputStream is;
        try {
            is = new FileInputStream(fn);
        } catch (FileNotFoundException e) {
            AlanLogger.e("Cannot read file: " + fn);
            AlanLogger.e(e);
            return null;
        }
        return BitmapFactory.decodeStream(is);
    }

    private void writeToFile(Context context, ByteArrayOutputStream byteArrayOutputStream, String fileName) {
        File folder = new File(context.getFilesDir(), CACHE_FOLDER);
        if (!folder.exists()) {
            if (!folder.mkdir()) {
                return;
            }
        }
        File fn = new File(folder, fileName);
        File parent = fn.getParentFile();
        if (parent == null) {
            return;
        }
        if (!parent.exists()) {
            if (!parent.mkdirs()) {
                return;
            }
        }
        try {
            if (!fn.createNewFile()) {
                return;
            }
        } catch (IOException e) {
            AlanLogger.e("Cannot create file: " + fn);
            AlanLogger.e(e);
            return;
        }
        try(OutputStream outputStream = new FileOutputStream(fn)) {
            byteArrayOutputStream.writeTo(outputStream);
        } catch (IOException e) {
            AlanLogger.e("Cannot create file: " + fn);
            AlanLogger.e(e);
        }
    }
}