package com.alan.alansdk;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;

import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.alan.alansdk.logging.AlanLogger;

public class AlanNotificationService extends Service {

    public static boolean isRunning = false;
    public static final String CHANNEL_ID = "AlanForegroundServiceChannelID";
    private static final  String TYPE = "type";

    @Override
    public void onCreate() {
        AlanLogger.i("Alan Notification service: onCreate");
        super.onCreate();
        isRunning = true;
    }

    @Override
    public void onDestroy() {
        AlanLogger.i("Alan Notification service: onDestroy");
        isRunning = false;
        stopForeground(true);
        stopSelf();
        super.onDestroy();
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        AlanLogger.i("Alan Notification service: onBind");
        return null;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        AlanLogger.i("Alan Notification service: onUnbind");
        return true;
    }

    @Override
    public void onRebind(Intent intent) {
        AlanLogger.i("Alan Notification service: onRebind");
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {
        AlanLogger.i("Alan Notification service: onTaskRemoved");
        isRunning = false;
        stopForeground(true);
        stopSelf();
        super.onTaskRemoved(rootIntent);
    }

    private Notification buildNotification(String text) {
        PackageManager pm = getPackageManager();
        Intent notificationIntent = pm.getLaunchIntentForPackage(getPackageName());
        notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, notificationIntent, PendingIntent.FLAG_IMMUTABLE);
        return new NotificationCompat.Builder(this, CHANNEL_ID)
                .setContentTitle("Alan AI")
                .setContentText(text)
                .setSmallIcon(R.drawable.ic_button_logo_state_01)
                .setContentIntent(pendingIntent)
                .build();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        AlanLogger.i("Alan Notification service: onStartCommand");
        if (intent == null) {
            return START_STICKY;
        }
        if (!intent.hasExtra(TYPE)) {
            String appName = getResources().getString(R.string.app_name);
            createNotificationChannel();
            Notification notification = buildNotification(appName + " is listening to your microphone");
            startForeground(1, notification);
        }
        return START_STICKY;
    }

    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel serviceChannel = new NotificationChannel(CHANNEL_ID, "Alan foreground service", NotificationManager.IMPORTANCE_LOW);
            NotificationManager manager = (NotificationManager) getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
            manager.createNotificationChannel(serviceChannel);
        }
    }
}
