package com.alan.alansdk.alanbase.recorder;

import android.annotation.TargetApi;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Build;

import com.alan.alansdk.alanbase.AudioConfig;
import com.alan.alansdk.logging.AlanLogger;

import java.util.Arrays;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
public class RecorderApi21 extends RecorderThread {

    private static final int BUFFER_SIZE_FACTOR = 2;
    private int samplesToSkip = 0;
    private short[] audioBuffer;

    @Override
    protected void skip(int samples) {
        samplesToSkip = samples;
    }

    public RecorderApi21(RecordDumpListener callback) {
        super(callback);
    }

    @Override
    protected boolean prepareRecorder() {
        int bufferSize = AudioRecord.getMinBufferSize(
                AudioConfig.SAMPLE_RATE,
                AudioFormat.CHANNEL_IN_MONO,
                AudioFormat.ENCODING_PCM_16BIT
        ) * BUFFER_SIZE_FACTOR;

        if (bufferSize == AudioRecord.ERROR || bufferSize == AudioRecord.ERROR_BAD_VALUE) {
            bufferSize = AudioConfig.SAMPLE_RATE * 2;
        }

        audioBuffer = new short[bufferSize];

        record = new AudioRecord(
                MediaRecorder.AudioSource.MIC,
                AudioConfig.SAMPLE_RATE,
                AudioFormat.CHANNEL_IN_MONO,
                AudioFormat.ENCODING_PCM_16BIT,
                bufferSize
        );

        if (record.getState() != AudioRecord.STATE_INITIALIZED) {
            AlanLogger.e("Audio Record can't initialize!");
            return false;
        }

        shouldContinue = true;
        return shouldContinue;
    }

    @Override
    protected void writeFrames() {
        if (audioBuffer.length > 0) {
            if (samplesToSkip > 0) {
                int skip = Math.min(audioBuffer.length, samplesToSkip);
                samplesToSkip -= skip;
                if (skip >= audioBuffer.length) {
                    return;
                } else {
                    short[] skippedBuffer = Arrays.copyOfRange(audioBuffer, skip, audioBuffer.length);
                    callback.onRecordDump(floatMe(skippedBuffer));
                }
            } else {
                callback.onRecordDump(floatMe(audioBuffer));
            }
        }
        if (audioBuffer.length > 0) {
            callback.onRecordDump(floatMe(audioBuffer));
        }
    }

    @Override
    protected int readBuffer() {
        return record.read(audioBuffer, 0, audioBuffer.length);
    }

    private float[] floatMe(short[] pcms) {
        float[] floaters = new float[pcms.length];
        for (int i = 0; i < pcms.length; i++) {
            floaters[i] = pcms[i];
        }
        return floaters;
    }
}
