package com.alan.alansdk.alanbase.recorder;

import android.media.AudioRecord;

import com.alan.alansdk.alanbase.AudioConfig;
import com.alan.alansdk.logging.AlanLogger;

abstract public class RecorderThread extends Thread {

    protected AudioRecord record;
    private DriftCompensator driftCompensator = new DriftCompensator();

    protected final RecordDumpListener callback;

    boolean shouldContinue = false;

    RecorderThread(RecordDumpListener callback) {
        this.callback = callback;
    }
    public void stopRecording() {
        shouldContinue = false;
    }

    public void skipSamples(int samples) {
        skip(samples);
    }

    public void skipMillis(int millis) {
        skip((int)Math.round((float)millis * AudioConfig.SAMPLE_RATE / 1000.0));
    }

    @Override
    public void run() {
        super.run();
        android.os.Process.setThreadPriority(android.os.Process.THREAD_PRIORITY_AUDIO);
        if (!prepareRecorder()) {
            AlanLogger.e(new IllegalStateException("Failed to prepare recorder"));
            return;
        }
        record.startRecording();
        AlanLogger.d("Start recording");
        while (shouldContinue) {
            prepareFrames();
        }

        record.stop();
        record.release();
        AlanLogger.d("Recording stopped.");
    }

    private void prepareFrames() {
        driftCompensator.prepare();
        int samplesRead = readBuffer();
        writeFrames();
        driftCompensator.compensate(samplesRead);
    }

    protected abstract void skip(int samples);

    protected abstract void writeFrames();

    protected abstract int readBuffer();

    protected abstract boolean prepareRecorder();
}
