package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class ButtonXAnimation {

    final private View button;

    public ButtonXAnimation(View buttonView) {
        this.button = buttonView;
    }

    public void animate(float newX) {
        AnimatorSet anim = new AnimatorSet();
        ObjectAnimator setXAnimation = getXAnimation(button, newX);
        anim.play(setXAnimation);
        anim.start();
    }

    private ObjectAnimator getXAnimation(View view, float target) {

        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                "x",
                view.getX(), target);

        animation.setDuration(AnimationConfig.BUTTON_X_ANIMATION_TIME);
        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}
