package com.alan.alansdk.alanbase.recorder;

import com.alan.alansdk.alanbase.AudioConfig;
import com.alan.alansdk.logging.AlanLogger;

public class DriftCompensator {

    private long timeStart = 0L;

    public void prepare() {
        timeStart = System.currentTimeMillis();
    }

    public void compensate(int samples) {
        long timeDiff = System.currentTimeMillis() - timeStart;
        long samplesDiff = Math.round(samples * 1000.0f / AudioConfig.SAMPLE_RATE);

        if (samplesDiff > timeDiff) {
            try {
                Thread.sleep(samplesDiff - timeDiff);
            } catch (InterruptedException e) {
                AlanLogger.e(e);
            }
        }
    }
}
