package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;

import com.alan.alansdk.button.GradientButton;
import com.alan.alansdk.events.EventOptions;

public class ButtonColorAnimation {

    final private GradientButton button;

    private EventOptions.AlanColor lastColor = null;
    protected AnimatorSet anim;

    private int firstColor;
    private int secondColor;

    public ButtonColorAnimation(
            GradientButton buttonBg
    ) {
        this.button = buttonBg;
    }

    public void start(final EventOptions.AlanColor alanColor, final OnAnimationEnd callback) {
        if (lastColor == null) {
            updateViews(alanColor.getFirstColor(), alanColor.getSecondColor());
            lastColor = alanColor;
            return;
        }

        anim = new AnimatorSet();
        anim.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                lastColor = alanColor;
                if (callback != null) {
                    callback.onAnimationEnd();
                }
                updateViews(alanColor.getFirstColor(), alanColor.getSecondColor());
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });

        firstColor = lastColor.getFirstColor();
        secondColor = lastColor.getSecondColor();

        ValueAnimator animator = getColorAnimation(lastColor.getFirstColor(), alanColor.getFirstColor());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                firstColor = (int) animation.getAnimatedValue();
//                updateViews(color, color);
            }
        });
        ValueAnimator animator2 = getColorAnimation(lastColor.getSecondColor(), alanColor.getSecondColor());
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                secondColor = (int) animation.getAnimatedValue();
                updateViews(firstColor, secondColor);
            }
        });

        anim.playTogether(animator, animator2);
        anim.start();
    }

    private void updateViews(int color1, int color2) {
        button.setColors(color1, color2);
    }

    private ValueAnimator getColorAnimation(int startColor, int endColor) {

        ValueAnimator animation = ValueAnimator.ofArgb(
                startColor, endColor);

        animation.setDuration(AnimationConfig.BUTTON_COLOR_ANIMATION_TIME);
        animation.setInterpolator(new LinearInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}
