package com.alan.alansdk.wakeword;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Environment;

import com.alan.alansdk.Utils;
import com.alan.alansdk.logging.AlanLogger;

import java.io.File;

import static android.content.Context.DOWNLOAD_SERVICE;

public class ModelDownloader {

    private DownloadListener callback;
    private String url;

    private BroadcastReceiver onComplete = new BroadcastReceiver() {
        public void onReceive(Context ctxt, Intent intent) {
            if (callback != null) {
                callback.onDownloaded(url);
            }
        }
    };

    private BroadcastReceiver onNotificationClick = new BroadcastReceiver() {
        public void onReceive(Context ctxt, Intent intent) {
            //Do nothing
        }
    };

    public void download(Context context,
                         DownloadListener downloadListener,
                         String path) {

        callback = downloadListener;
        this.url = path;

        DownloadManager mgr = (DownloadManager) context.getSystemService(DOWNLOAD_SERVICE);

        if (mgr == null) {
            if (callback != null) {
                callback.onDownloadFailed();
            }
            return;
        }

        context.registerReceiver(onComplete,
                new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE));
        context.registerReceiver(onNotificationClick,
                new IntentFilter(DownloadManager.ACTION_NOTIFICATION_CLICKED));

        startDownload(context, mgr, path);
    }

    private void startDownload(Context context,
                               DownloadManager mgr,
                               String modelPath) {
        try {
            Uri uri = Uri.parse(modelPath);


            String modelName = Utils.extractFileNameFromUrl(modelPath);
            File localPath = Utils.getWakeWordModelFile(context, modelName);

            long lastDownload =
                    mgr.enqueue(new DownloadManager.Request(uri)
                                    .setAllowedNetworkTypes(DownloadManager.Request.NETWORK_WIFI |
                                            DownloadManager.Request.NETWORK_MOBILE)
                                    .setAllowedOverRoaming(false)
                                    .setTitle("Updating")
                                    .setDescription("")
                                    .setDestinationInExternalFilesDir(context, Environment.DIRECTORY_DOWNLOADS, "wakeword/" + modelName)
//                        .setDestinationUri(Uri.fromFile(localPath))
                    );
        } catch (Exception e) {
            AlanLogger.e("Failed to download model: " + modelPath);
        }
    }
}
