package app.appnomix.sdk.internal.data.local

import app.appnomix.sdk.internal.data.network.model.ConfigContentDto

data class DynamicConfig(
    val campaignId: String,
    val dataRefreshPeriodMillis: Long,
    val popupSnoozeTimeMillis: Long
)

fun ConfigContentDto.toDynamicConfig(): DynamicConfig {
    return DynamicConfig(
        campaignId = this.config.campaignId,
        dataRefreshPeriodMillis = this.config.dataRefreshPeriodMillis,
        popupSnoozeTimeMillis = this.config.popupSnoozeTimeMillis,
    )
}
