package app.appnomix.sdk.internal.ui

import android.content.Context
import android.graphics.Bitmap
import android.util.AttributeSet
import android.webkit.WebView
import android.webkit.WebViewClient
import app.appnomix.sdk.internal.utils.SLog

class OverlayWebview(context: Context, attrs: AttributeSet?) : WebView(context, attrs) {

    init {
        webViewClient = object : WebViewClient() {
            override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
                super.onPageStarted(view, url, favicon)
                SLog.i("onPageStarted: $url")
            }

            override fun onPageFinished(view: WebView, url: String?) {
                super.onPageFinished(view, url)
                SLog.i("onPageFinished: $url")
            }
        }
    }
}
