package app.appnomix.sdk.internal.ui.onboarding

import androidx.annotation.ColorRes
import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import app.appnomix.sdk.R

data class OnboardingScreenData(
    val content: OnboardingContent,
    @StringRes val titleRes: Int?,
    @StringRes val mainButtonTitleRes: Int,
    @StringRes val secondaryButtonTitleRes: Int?,
    @ColorRes val secondaryButtonTextColorRes: Int? = null,
    @DrawableRes val secondaryButtonDrawableRes: Int = R.drawable.transparent_bg,
)

sealed class OnboardingContent {
    data class ImageText(
        @DrawableRes val imageDrawableRes: Int,
        @StringRes val textRes: Int,
    ) : OnboardingContent()

    data class TextImage(
        @DrawableRes val imageDrawableRes: Int,
        @StringRes val textRes: Int,
    ) : OnboardingContent()


    data class TextWithMore(
        @StringRes val textRes: Int,
    ) : OnboardingContent()

    data class Image(
        @DrawableRes val imageDrawableRes: Int,
    ) : OnboardingContent()
}

enum class OnboardingScreenType(val order: Int) {
    GET_STARTED_1(0),
    GET_STARTED_2(1),
    ACCESSIBILITY_PERMISSION_EXPLAINER(2),
    ACCESSIBILITY_PERMISSION_STEP_1(3),
    ACCESSIBILITY_PERMISSION_STEP_2(4),
    SETUP_DONE(5),
}

val ONBOARDING_SCREENS = mapOf(
    OnboardingScreenType.GET_STARTED_1 to OnboardingScreenData(
        titleRes = R.string.onboarding_title_1,
        content = OnboardingContent.ImageText(
            imageDrawableRes = R.drawable.onboarding_first,
            textRes = R.string.onboarding_description_1
        ),
        mainButtonTitleRes = R.string.get_started,
        secondaryButtonTitleRes = null
    ),

    OnboardingScreenType.GET_STARTED_2 to OnboardingScreenData(
        titleRes = R.string.onboarding_title_2,
        content = OnboardingContent.ImageText(
            imageDrawableRes = R.drawable.onboarding_second,
            textRes = R.string.no_coupon_popup_text
        ),
        mainButtonTitleRes = R.string.yes_please,
        secondaryButtonTitleRes = R.string.skip_for_now,
        secondaryButtonTextColorRes = R.color.sdk_surfaceTint
    ),

    OnboardingScreenType.ACCESSIBILITY_PERMISSION_EXPLAINER to OnboardingScreenData(
        titleRes = R.string.accessibility_permission,
        content = OnboardingContent.TextWithMore(
            textRes = R.string.accessibility_permission_explainer
        ),
        mainButtonTitleRes = R.string.agree,
        secondaryButtonTitleRes = R.string.disagree,
        secondaryButtonTextColorRes = R.color.sdk_surfaceTint,
        secondaryButtonDrawableRes = R.drawable.transparent_bg_bordered_button
    ),

    OnboardingScreenType.ACCESSIBILITY_PERMISSION_STEP_1 to OnboardingScreenData(
        titleRes = R.string.activate_savers_league,
        content = OnboardingContent.TextImage(
            imageDrawableRes = R.drawable.access_1,
            textRes = R.string.accessibility_walk_1
        ),
        mainButtonTitleRes = R.string.next,
        secondaryButtonTitleRes = R.string.skip_for_now,
        secondaryButtonTextColorRes = R.color.sdk_outlineVariant,
    ),

    OnboardingScreenType.ACCESSIBILITY_PERMISSION_STEP_2 to OnboardingScreenData(
        titleRes = R.string.activate_savers_league,
        content = OnboardingContent.TextImage(
            imageDrawableRes = R.drawable.access_2,
            textRes = R.string.accessibility_walk_2
        ),
        mainButtonTitleRes = R.string.enable,
        secondaryButtonTitleRes = R.string.skip_for_now,
        secondaryButtonTextColorRes = R.color.sdk_outlineVariant,
    ),

    OnboardingScreenType.SETUP_DONE to OnboardingScreenData(
        titleRes = R.string.setup_complete,
        content = OnboardingContent.Image(
            imageDrawableRes = R.drawable.onboarding_first,
        ),
        mainButtonTitleRes = R.string.start_saving,
        secondaryButtonTitleRes = null
    ),
)