/*
 * Decompiled with CFR 0.152.
 */
package app.appnomix.sdk.external;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ServiceInfo;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.DrawableRes;
import androidx.work.Constraints;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import app.appnomix.sdk.external.CouponsSdkFacade;
import app.appnomix.sdk.external.ExternalCoupon;
import app.appnomix.sdk.external.ExternalCouponsReadyListener;
import app.appnomix.sdk.external.SdkRequirement;
import app.appnomix.sdk.external.a;
import app.appnomix.sdk.internal.CouponsAccessibilityService;
import app.appnomix.sdk.internal.data.network.CouponsSyncWorker;
import app.appnomix.sdk.internal.ui.onboarding.OnboardingActivity;
import b.c;
import c.b;
import f.i;
import h.p;
import h.q;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\u0006J\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b!\u0010 J\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010 R\u001b\u0010(\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001b\u0010-\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010%\u001a\u0004\b+\u0010,R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R \u00102\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u00028\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00069"}, d2={"Lapp/appnomix/sdk/external/CouponsSdkFacade;", "Lh/q;", "Landroid/content/Context;", "context", "", "performInitJobs", "(Landroid/content/Context;)V", "schedulePeriodicCouponsSync", "schedulePeriodicLocationRefresh", "initialize", "Lapp/appnomix/sdk/external/CouponsSdkFacade$Config;", "config", "setup", "(Lapp/appnomix/sdk/external/CouponsSdkFacade$Config;)V", "", "Lapp/appnomix/sdk/external/SdkRequirement;", "unmetRequirements", "()Ljava/util/List;", "", "isAccessibilityServiceEnabled", "()Z", "Lapp/appnomix/sdk/external/ExternalCouponsReadyListener;", "listener", "registerCouponsReadyListener", "(Lapp/appnomix/sdk/external/ExternalCouponsReadyListener;)V", "Lj/b;", "coupons", "onCouponsUpdated", "(Ljava/util/List;)V", "Landroid/app/Activity;", "activity", "launchSdkOnboardingActivity", "(Landroid/app/Activity;)V", "goToToAccessibilityOnboarding", "goToToAccessibilitySettings", "Lh/p;", "couponsRepo$delegate", "Lkotlin/Lazy;", "getCouponsRepo", "()Lh/p;", "couponsRepo", "Lb/c;", "sdkConfig$delegate", "getSdkConfig", "()Lb/c;", "sdkConfig", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Ljava/lang/ref/WeakReference;", "weakListener", "Ljava/lang/ref/WeakReference;", "appContext", "Landroid/content/Context;", "<init>", "()V", "Config", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nCouponsSdkFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouponsSdkFacade.kt\napp/appnomix/sdk/external/CouponsSdkFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n766#2:146\n857#2,2:147\n1549#2:149\n1620#2,3:150\n*S KotlinDebug\n*F\n+ 1 CouponsSdkFacade.kt\napp/appnomix/sdk/external/CouponsSdkFacade\n*L\n113#1:146\n113#1:147,2\n114#1:149\n114#1:150,3\n*E\n"})
public final class CouponsSdkFacade
implements q {
    @NotNull
    public static final CouponsSdkFacade INSTANCE = new CouponsSdkFacade();
    @NotNull
    private static final Lazy couponsRepo$delegate = LazyKt.lazy((Function0)couponsRepo.2.INSTANCE);
    @NotNull
    private static final Lazy sdkConfig$delegate = LazyKt.lazy((Function0)sdkConfig.2.INSTANCE);
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    @Nullable
    private static WeakReference<ExternalCouponsReadyListener> weakListener;
    private static Context appContext;

    private CouponsSdkFacade() {
    }

    private final p getCouponsRepo() {
        return (p)couponsRepo$delegate.getValue();
    }

    private final c getSdkConfig() {
        return (c)sdkConfig$delegate.getValue();
    }

    private final void performInitJobs(Context object) {
        AtomicBoolean atomicBoolean = initialized;
        if (!atomicBoolean.get()) {
            try {
                CouponsSdkFacade couponsSdkFacade = this;
                couponsSdkFacade.schedulePeriodicCouponsSync((Context)object);
                couponsSdkFacade.schedulePeriodicLocationRefresh((Context)object);
                atomicBoolean.set(true);
            }
            catch (Throwable throwable) {
                object = "Something went wrong while setting up the SDK";
                Intrinsics.checkNotNullParameter((Object)"Something went wrong while setting up the SDK", (String)"message");
                Log.e((String)"[SLC]", (String)object, (Throwable)throwable);
            }
        }
    }

    private final void schedulePeriodicCouponsSync(Context object) {
        if (StringsKt.isBlank((CharSequence)couponsSdkFacade2.getSdkConfig().g) ^ true && StringsKt.isBlank((CharSequence)couponsSdkFacade2.getSdkConfig().f) ^ true) {
            CouponsSdkFacade couponsSdkFacade = couponsSdkFacade2;
            CouponsSdkFacade couponsSdkFacade2 = WorkManager.getInstance((Context)object);
            Intrinsics.checkNotNullExpressionValue((Object)couponsSdkFacade2, (String)"getInstance(...)");
            object = "coupons-sync-worker";
            ExistingPeriodicWorkPolicy existingPeriodicWorkPolicy = ExistingPeriodicWorkPolicy.KEEP;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            b b2 = couponsSdkFacade.getSdkConfig().c;
            long l2 = b2 != null ? b2.b : Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)12, (DurationUnit)DurationUnit.HOURS));
            long l3 = timeUnit.toHours(l2);
            timeUnit = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
            TimeUnit timeUnit2 = TimeUnit.HOURS;
            couponsSdkFacade2.enqueueUniquePeriodicWork((String)object, existingPeriodicWorkPolicy, (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(CouponsSyncWorker.class, l3, timeUnit2).setConstraints((Constraints)timeUnit)).build());
            return;
        }
        throw new RuntimeException("Cannot schedule data sync, as sdk isn't fully initialized (missing config auth/clientId)");
    }

    private final void schedulePeriodicLocationRefresh(Context context) {
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(...)");
        CouponsSdkFacade couponsSdkFacade = i.a();
        workManager.enqueueUniquePeriodicWork("location-sync-worker", ExistingPeriodicWorkPolicy.KEEP, (PeriodicWorkRequest)couponsSdkFacade);
    }

    public final void initialize(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        appContext = context2;
    }

    public final void setup(@NotNull Config config) {
        CouponsSdkFacade couponsSdkFacade = this;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        couponsSdkFacade.getSdkConfig().e = config.getAppIconRes();
        c c2 = couponsSdkFacade.getSdkConfig();
        String string2 = config.getAuthToken();
        c2.getClass();
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        couponsSdkFacade.getSdkConfig().g = string2;
        c2 = couponsSdkFacade.getSdkConfig();
        String string3 = config.getClientId();
        c2.getClass();
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<set-?>");
        couponsSdkFacade.getSdkConfig().f = string3;
        config = appContext;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            config = null;
        }
        this.performInitJobs((Context)config);
    }

    @NotNull
    public final List<SdkRequirement> unmetRequirements() {
        ArrayList arrayList;
        boolean bl = ((CouponsSdkFacade)((Object)arrayList2)).isAccessibilityServiceEnabled();
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        if (!bl) {
            arrayList2.add(SdkRequirement.ACCESSIBILITY);
        }
        return arrayList2;
    }

    public final boolean isAccessibilityServiceEnabled() {
        Object object = appContext;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            object = null;
        }
        Object object2 = object.getSystemService("accessibility");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        object = ((AccessibilityManager)object2).getEnabledAccessibilityServiceList(-1).iterator();
        while (object.hasNext()) {
            ServiceInfo serviceInfo = ((AccessibilityServiceInfo)object.next()).getResolveInfo().serviceInfo;
            String string2 = serviceInfo.packageName;
            Context context = appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
                context = null;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)context.getPackageName()) || !Intrinsics.areEqual((Object)serviceInfo.name, (Object)CouponsAccessibilityService.class.getName())) continue;
            return true;
        }
        return false;
    }

    public final void registerCouponsReadyListener(@NotNull ExternalCouponsReadyListener object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"listener");
        weakListener = new WeakReference<ExternalCouponsReadyListener>((ExternalCouponsReadyListener)object);
        object = ((CouponsSdkFacade)this).getCouponsRepo();
        object.getClass();
        Intrinsics.checkNotNullParameter((Object)this, (String)"listener");
        ((p)object).k = new WeakReference<CouponsSdkFacade>((CouponsSdkFacade)this);
        if (((p)object).i.isEmpty() ^ true && (this = ((p)object).k) != null && (this = (q)((Reference)this).get()) != null) {
            this.onCouponsUpdated(CollectionsKt.toList((Iterable)((p)object).i));
        }
    }

    public void onCouponsUpdated(@NotNull List<j.b> object) {
        Intrinsics.checkNotNullParameter(object, (String)"coupons");
        Object object2 = weakListener;
        if (object2 != null && (object2 = (ExternalCouponsReadyListener)((Reference)object2).get()) != null) {
            ArrayList arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3 = object;
            object = arrayList2;
            arrayList2 = new ArrayList();
            for (Object object3 : arrayList3) {
                if (!(((j.b)object3).g ^ true)) continue;
                object.add(object3);
            }
            ArrayList arrayList4 = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                Object object3;
                j.b b2 = (j.b)object.next();
                Intrinsics.checkNotNullParameter((Object)b2, (String)"<this>");
                object3 = b2.a;
                String string2 = b2.f;
                String string3 = b2.i;
                String string4 = b2.e;
                String string5 = b2.b;
                String string6 = b2.h;
                arrayList4.add(new ExternalCoupon((String)object3, string2, string5, string3, string2, string4, string6));
            }
            object2.onCouponsAvailable(arrayList4);
        }
    }

    public final void launchSdkOnboardingActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!couponsSdkFacade.getSdkConfig().b().getBoolean("onboarding_finished", false)) {
            Intent intent;
            CouponsSdkFacade couponsSdkFacade = intent;
            intent = new Intent((Context)activity, OnboardingActivity.class);
            activity.startActivity((Intent)couponsSdkFacade);
        }
    }

    public final void goToToAccessibilityOnboarding(@NotNull Activity activity) {
        Intent intent;
        Activity activity2 = activity;
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        CouponsSdkFacade couponsSdkFacade = intent;
        new Intent((Context)activity, OnboardingActivity.class).setAction("action_to_accessibility");
        activity2.startActivity((Intent)couponsSdkFacade);
    }

    public final void goToToAccessibilitySettings(@NotNull Activity activity) {
        Intent intent;
        Activity activity2 = activity;
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        CouponsSdkFacade couponsSdkFacade = intent;
        intent = new Intent("android.settings.ACCESSIBILITY_SETTINGS");
        activity2.startActivity((Intent)couponsSdkFacade);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lapp/appnomix/sdk/external/CouponsSdkFacade$Config;", "", "appIconRes", "", "authToken", "", "clientId", "(ILjava/lang/String;Ljava/lang/String;)V", "getAppIconRes", "()I", "getAuthToken", "()Ljava/lang/String;", "getClientId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "sdk_release"})
    public static final class Config {
        private final int appIconRes;
        @NotNull
        private final String authToken;
        @NotNull
        private final String clientId;

        public Config(@DrawableRes int n2, @NotNull String string2, @NotNull String string3) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"authToken");
            Intrinsics.checkNotNullParameter((Object)string3, (String)"clientId");
            this.appIconRes = n2;
            this.authToken = string2;
            this.clientId = string3;
        }

        public /* synthetic */ Config(int n2, String string2, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n2 = 0;
            }
            this(n2, string2, string3);
        }

        public static /* synthetic */ Config copy$default(Config config, int n2, String string2, String string3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n2 = config.appIconRes;
            }
            if ((n3 & 2) != 0) {
                string2 = config.authToken;
            }
            if ((n3 & 4) != 0) {
                string3 = config.clientId;
            }
            return config.copy(n2, string2, string3);
        }

        public final int getAppIconRes() {
            return this.appIconRes;
        }

        @NotNull
        public final String getAuthToken() {
            return this.authToken;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        public final int component1() {
            return this.appIconRes;
        }

        @NotNull
        public final String component2() {
            return this.authToken;
        }

        @NotNull
        public final String component3() {
            return this.clientId;
        }

        @NotNull
        public final Config copy(@DrawableRes int n2, @NotNull String string2, @NotNull String string3) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"authToken");
            Intrinsics.checkNotNullParameter((Object)string3, (String)"clientId");
            return new Config(n2, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Config(appIconRes=" + this.appIconRes + ", authToken=" + this.authToken + ", clientId=" + this.clientId + ')';
        }

        public int hashCode() {
            Config config = this;
            int n2 = Integer.hashCode(config.appIconRes) * 31;
            n2 = a.a(config.authToken, n2, 31);
            return config.clientId.hashCode() + n2;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Config)) {
                return false;
            }
            object = (Config)object;
            if (this.appIconRes != ((Config)object).appIconRes) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authToken, (Object)((Config)object).authToken)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.clientId, (Object)((Config)object).clientId);
        }
    }
}

