package app.appnomix.sdk.internal.data.local.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import app.appnomix.sdk.internal.data.local.model.CouponEntity
import java.time.LocalDateTime

@Dao
interface CouponDao {

    @Query("SELECT * FROM coupon")
    suspend fun getAll(): List<CouponEntity>

    @Transaction
    suspend fun replace(items: List<CouponEntity>) {
        deleteAll()
        save(items)
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun save(voicemails: List<CouponEntity>)

    @Query("DELETE FROM coupon")
    suspend fun deleteAll()

    @Query("UPDATE coupon SET snooze_time=:time WHERE brand_domain=:brandDomain")
    suspend fun updateBrandSnooze(time: LocalDateTime, brandDomain: String)
}
