package app.appnomix.sdk.internal.data.local

import app.appnomix.sdk.internal.data.network.model.ConfigContentDto
import kotlinx.serialization.Serializable

data class DynamicConfig(
    val campaignId: String,
    val dataRefreshPeriodMillis: Long,
    val popupSnoozeTimeMillis: Long,
    val analyticsUrlPath: String,
    val overrides: Map<String, OverrideInfo>
)

@Serializable
data class OverrideInfo(val campaignId: String)

fun DynamicConfig.getOverrideCampaignId(overrideKey: String): String? {
    return this.overrides.mapKeys { (key) ->
        key.lowercase()
    }[overrideKey.lowercase()]?.campaignId
}

fun ConfigContentDto.toDynamicConfig(): DynamicConfig {
    val overrideInfo: MutableMap<String, OverrideInfo> = mutableMapOf()
    this.config.overrides?.mapKeys {
        overrideInfo[it.key] = OverrideInfo(it.value.campaignId)
    }
    return DynamicConfig(
        campaignId = this.config.campaignId,
        dataRefreshPeriodMillis = this.config.dataRefreshPeriodMillis,
        popupSnoozeTimeMillis = this.config.popupSnoozeTimeMillis,
        analyticsUrlPath = this.config.analyticsEndpoint,
        overrides = overrideInfo
    )
}
