package app.appnomix.sdk.internal.data.local.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import app.appnomix.sdk.internal.data.local.model.ConfigEntity

@Dao
interface ConfigDao {

    @Query("SELECT * FROM config LIMIT 1")
    suspend fun get(): ConfigEntity?

    @Transaction
    suspend fun replace(config: ConfigEntity) {
        deleteAll()
        save(config)
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun save(config: ConfigEntity)

    @Query("DELETE FROM demand")
    suspend fun deleteAll()
}
