package app.appnomix.sdk.internal.data.local.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import app.appnomix.sdk.internal.data.local.DynamicConfig
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

@Entity(tableName = "config")
data class ConfigEntity(
    @ColumnInfo(name = "id") @PrimaryKey val campaignId: String,
    @ColumnInfo(name = "data_refresh_period_millis") val dataRefreshPeriodMillis: Long,
    @ColumnInfo(name = "popup_snooze_time_millis") val popupSnoozeTimeMillis: Long,
    @ColumnInfo(name = "analytics_url_path") val analyticsUrlPath: String,
    @ColumnInfo(name = "overrides") val overrides: String
)

fun DynamicConfig.toEntity(): ConfigEntity {
    return ConfigEntity(
        campaignId = this.campaignId,
        dataRefreshPeriodMillis = this.dataRefreshPeriodMillis,
        popupSnoozeTimeMillis = this.popupSnoozeTimeMillis,
        analyticsUrlPath = this.analyticsUrlPath,
        overrides = Json.encodeToString(this.overrides)
    )
}

fun ConfigEntity.toConfig(): DynamicConfig {
    return DynamicConfig(
        campaignId = this.campaignId,
        dataRefreshPeriodMillis = this.dataRefreshPeriodMillis,
        popupSnoozeTimeMillis = this.popupSnoozeTimeMillis,
        analyticsUrlPath = this.analyticsUrlPath,
        overrides = Json.decodeFromString(this.overrides)
    )
}
