package app.appnomix.sdk.internal.data.network.model

import app.appnomix.sdk.BuildConfig
import app.appnomix.sdk.internal.analytics.AnalyticsEvent
import app.appnomix.sdk.internal.analytics.AnalyticsName
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import java.time.OffsetDateTime
import java.util.UUID

@Serializable
data class AnalyticsEventDto(
    @SerialName("event_id") val eventId: String = UUID.randomUUID().toString(),
    @SerialName("event_type") val eventType: String,
    @SerialName("event_category") val eventCategory: String,
    @Serializable(TimestampWithOffsetSerializer::class) @SerialName("user_timestamp") val userTimestamp: OffsetDateTime,
    @SerialName("source") val source: String,
    @SerialName("payload") val payload: Map<String, String>,
)

fun AnalyticsEvent.toDto(
    campaignId: String?,
    source: String,
    userId: String,
    appVersion: String,
): AnalyticsEventDto =
    AnalyticsEventDto(
        eventType = name,
        eventCategory = category.value,
        userTimestamp = timestamp,
        source = source,
        payload = payload.toMutableMap().apply {
            if (campaignId?.isNotEmpty() == true) {
                put(AnalyticsName.EventPayloadKey.CAMPAIGN_ID, campaignId)
            }
            if (userId.isNotEmpty()) {
                put(AnalyticsName.EventPayloadKey.USER_ID, userId)
            }
            put(AnalyticsName.EventPayloadKey.PRODUCTION, "${!BuildConfig.DEBUG}")
            put(AnalyticsName.EventPayloadKey.APP_VERSION, appVersion)
            put(AnalyticsName.EventPayloadKey.SDK_VERSION, BuildConfig.LIBRARY_PACKAGE_NAME)
            put(AnalyticsName.EventPayloadKey.OS, "android")
        }
    )

@Serializable
data class AnalyticsEventsDto(
    @SerialName("events") val events: List<AnalyticsEventDto>,
)