package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView

data object ApplyErrorVerifierNode : TreeNode() {

    override suspend fun execute() {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val checkoutPageConfig =
            inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (checkoutPageConfig != null && webView != null) {
            val applyErrorSelector = checkoutPageConfig.selectorCouponError ?: ""

            val hasError = evaluateSelector(
                webView = webView,
                selector = applyErrorSelector
            )
            if (hasError) {
                markReadyForTransition(TreeTransition.Negative)
            } else {
                markReadyForTransition(TreeTransition.Positive)
            }
        }
    }

    private suspend fun evaluateSelector(
        webView: WebView,
        selector: String,
    ): Boolean {
        if (selector.isEmpty()) return false
        val jsCode = """
        (function() {
            var input = document.querySelector(`$selector`);
            if (input) {
                return true;
            }
            return false;
        })();
    """

        val result = evaluateJs<Boolean>(webView, jsCode)
        return if (result is JsResult.Success)
            result.value
        else false
    }

    override fun positiveChildNode(): TreeNode = NewTotalVerifierNode
}
