package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import app.appnomix.sdk.internal.domain.model.Coupon

data object AutoApplyDataVerifierNode : TreeNode() {

    override suspend fun execute() {
        val checkoutConfig = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (checkoutConfig != null) {
            val hasConfigs = !checkoutConfig.selectorCouponInput.isNullOrEmpty()
            val hasCoupons =
                inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST)?.isNotEmpty() == true

            markReadyForTransition(if (hasCoupons && hasConfigs) TreeTransition.Positive else TreeTransition.Negative)
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }

    override fun positiveChildNode() = GetCartInitialTotalNode

    override fun negativeChildNode(): TreeNode {
        val checkoutConfig = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        val couponList = inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST) ?: listOf()

        val isOnCheckoutPageWithValidConfig = !checkoutConfig?.selectorCouponInput.isNullOrEmpty()

        return if (isOnCheckoutPageWithValidConfig && couponList.isNotEmpty())
            ShowCopyCodeNode
        else
            TerminalNode
    }
}
