package app.appnomix.sdk.internal.domain.machine.states

import app.appnomix.sdk.internal.Deps
import app.appnomix.sdk.internal.domain.CouponsRepo
import app.appnomix.sdk.internal.utils.SLog
import extractBaseDomain

data object DemandVerifierNode : TreeNode() {
    private val repo: CouponsRepo by lazy { Deps.repo() }

    override suspend fun execute() {
        inventory?.get<String>(TreeInventoryType.CURRENT_URL)?.let { url ->
            val domain = extractBaseDomain(url)
            if (repo.hasActiveDemand(domain)) {
                SLog.d("active demands: ${repo.getDemands(domain)}")
                markReadyForTransition(TreeTransition.Positive)
            } else {
                markReadyForTransition(TreeTransition.Negative)
            }
        }
    }

    override fun positiveChildNode() = ShowDemandApplierNode
    override fun negativeChildNode() = AutoApplyConfigProvisionNode
}
