package app.appnomix.sdk.internal.domain.machine.states

import app.appnomix.sdk.internal.domain.machine.states.analytics.logCheckoutLoadedAnalytics

data object GetCartInitialTotalNode : GetCartTotalNode() {

    override suspend fun execute() {
        val total = getCartTotal()
        inventory?.save(TreeInventoryType.CART_INITIAL_TOTAL, total)
        if (total != null && total > 0) {
            logCheckoutLoadedAnalytics(total)
            markReadyForTransition(TreeTransition.Positive)
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }

    override fun positiveChildNode(): TreeNode = ShowAutoApplyAskNode
    override fun negativeChildNode(): TreeNode = ShowCopyCodeNode
}
