package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.content.Context
import app.appnomix.sdk.R
import app.appnomix.sdk.internal.domain.machine.states.analytics.logShowAutoApplyAskAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logStartAutoApplyAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logStartAutoApplyTryLaterAnalytics
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewData
import app.appnomix.sdk.internal.ui.PopupViewType

data object ShowAutoApplyAskNode : UiTreeNode() {
    override suspend fun execute() {
        val popupDisplay = inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (config != null) {
            performInMainScope {
                logShowAutoApplyAskAnalytics()
                popupDisplay?.hide()
                showAutoApplyAskView(popupDisplay)
            }
        }
    }

    private fun showAutoApplyAskView(popupDisplay: PopupDisplay?) {
        popupDisplay?.show(
            viewType = PopupViewType.AUTO_APPLY_ASK,
            onConfirmAction = {
                logStartAutoApplyAnalytics()
                popupDisplay.hide()
                markReadyForTransition(TreeTransition.Positive)
            },
            onDismissAction = {
                logStartAutoApplyTryLaterAnalytics()
                showFabView(popupDisplay)
            },
        )
    }

    private fun showFabView(popupDisplay: PopupDisplay?) {
        val context = inventory?.get<Context>(TreeInventoryType.CONTEXT)
        val description = context?.getString(R.string.tap_to_save) ?: ""

        popupDisplay?.show(
            viewType = PopupViewType.FAB_MESSAGE,
            onConfirmAction = {
                showAutoApplyAskView(popupDisplay = popupDisplay)
            },
            data = PopupViewData().apply {
                set(
                    PopupViewData.PopupViewDataType.SECONDARY_MESSAGE,
                    description
                )
            }
        )
    }

    override fun pause() {
        performInMainScope {
            inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)?.apply {
                if (activePopupType() == PopupViewType.AUTO_APPLY_ASK || activePopupType() == PopupViewType.FAB_MESSAGE) {
                    hide()
                }
            }
        }
    }

    override fun positiveChildNode() = ShowAutoApplyProgressNode
}
