package app.appnomix.sdk.internal.domain.machine.states

import android.content.Context
import app.appnomix.sdk.internal.Deps
import app.appnomix.sdk.internal.data.SdkConfig
import app.appnomix.sdk.internal.domain.CouponsRepo
import app.appnomix.sdk.internal.domain.browsers.UrlFollower
import app.appnomix.sdk.internal.domain.browsers.ensureHttpsPrefix
import app.appnomix.sdk.internal.domain.model.Demand
import extractBaseDomain

data object ShowDemandApplierNode : UiTreeNode() {
    private val repo: CouponsRepo by lazy { Deps.repo() }
    private val sdkConfig: SdkConfig by lazy { Deps.sdkConfig() }

    override suspend fun execute() {
        inventory?.get<String>(TreeInventoryType.CURRENT_URL)?.let { url ->
            val activeDemands = repo.getDemands(extractBaseDomain(url))
            val activeDemand = activeDemands.firstOrNull { it.matchesTarget(url) }
            if (activeDemand != null) {
                followDemandRedirect(currentUrl = url, demand = activeDemand)
            } else {
                markReadyForTransition(TreeTransition.Negative)
            }
        }
    }

    override fun positiveChildNode() = TerminalNode
    override fun negativeChildNode() = AutoApplyConfigProvisionNode

    private suspend fun followDemandRedirect(
        demand: Demand,
        currentUrl: String
    ) {
        val urlFollower = inventory?.get<UrlFollower>(TreeInventoryType.URL_FOLLOWER)
        val context = inventory?.get<Context>(TreeInventoryType.CONTEXT)
        if (urlFollower != null && context != null) {
            repo.markAsUsed(demand)

            performInMainScope {
                urlFollower.follow(
                    context = context,
                    currentUrl = currentUrl,
                    destinationUrl = demand.redirectUrl.ensureHttpsPrefix(),
                    sdkConfig = sdkConfig
                )
                markReadyForTransition(TreeTransition.Positive)
            }
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }
}
