package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyNoDiscountContinueToCheckoutAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyNoDiscountShowAnalytics
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewType

data object ShowNoSavingsFoundNode : UiTreeNode() {
    override suspend fun execute() {
        val popupDisplay = inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (config != null) {
            logAutoApplyNoDiscountShowAnalytics()

            performInMainScope {
                logAutoApplyNoDiscountContinueToCheckoutAnalytics()
                popupDisplay?.hide()
                popupDisplay?.show(
                    viewType = PopupViewType.NO_SAVINGS_FOUND,
                    onConfirmAction = {
                        popupDisplay.hide()
                        markReadyForTransition(TreeTransition.Positive)
                    }
                )
            }
        }
    }

    override fun pause() {
        performInMainScope {
            inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)?.apply {
                if (activePopupType() == PopupViewType.NO_SAVINGS_FOUND) {
                    hide()
                }
            }
        }
    }

    override fun positiveChildNode() = TerminalNode
}
