package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.content.Context
import app.appnomix.sdk.R
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyProgressStopAndApplyAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyStopAndApplyGoToCartAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyStopAndApplyKeepSearchingAnalytics
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewData
import app.appnomix.sdk.internal.ui.PopupViewType
import app.appnomix.sdk.internal.utils.SLog

data object ShowStopProgressNode : UiTreeNode() {

    override suspend fun execute() {
        val popupDisplay = inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)

        if (config != null && popupDisplay != null) {
            performInMainScope { displayConfirmation(popupDisplay) }
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }

    private fun displayConfirmation(popupDisplay: PopupDisplay) {
        val bestCouponIndex = inventory?.get<Int>(TreeInventoryType.BEST_COUPON_INDEX_DETECTED)
        if (bestCouponIndex != null) {
            logAutoApplyProgressStopAndApplyAnalytics()
            val couponList = inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST)
            val bestCoupon = couponList?.getOrNull(bestCouponIndex)
            val initialTotal = inventory?.get<Double>(TreeInventoryType.CART_INITIAL_TOTAL)
                ?: 0.0
            val newTotal = inventory?.get<Double>(TreeInventoryType.CART_NEW_TOTAL)

            val savings = initialTotal.minus(newTotal ?: initialTotal)
            SLog.i("[aa] current savings: $savings")

            val data = PopupViewData().apply {
                bestCoupon?.let { set(PopupViewData.PopupViewDataType.COUPON, bestCoupon) }
                set(
                    PopupViewData.PopupViewDataType.TOTAL_SAVINGS,
                    "%.2f".format(savings).toDouble()
                )
                inventory?.get<String>(TreeInventoryType.CURRENCY_SYMBOL)?.let {
                    set(PopupViewData.PopupViewDataType.CURRENCY_SYMBOL, it)
                }
            }
            popupDisplay.show(
                PopupViewType.STOP_AND_APPLY_CONFIRMATION,
                data = data,
                onConfirmAction = {
                    logAutoApplyStopAndApplyKeepSearchingAnalytics()
                    popupDisplay.hide()
                    markReadyForTransition(TreeTransition.Positive)
                },
                onDismissAction = {
                    logAutoApplyStopAndApplyGoToCartAnalytics()
                    showFabView(popupDisplay)
                }
            )
        } else {
            performInMainScope { showFabView(popupDisplay) }
        }
    }

    private fun showFabView(popupDisplay: PopupDisplay?) {
        val context = inventory?.get<Context>(TreeInventoryType.CONTEXT)
        val description = context?.getString(R.string.find_saved_coupons) ?: ""

        popupDisplay?.show(
            viewType = PopupViewType.FAB_MESSAGE,
            onConfirmAction = {
                resume(ShowAutoApplyProgressNode)
            },
            data = PopupViewData().apply {
                set(
                    PopupViewData.PopupViewDataType.SECONDARY_MESSAGE,
                    description
                )
            }
        )
    }

    override fun pause() {
        performInMainScope {
            inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)?.apply {
                when (activePopupType()) {
                    PopupViewType.STOP_AND_APPLY_CONFIRMATION, PopupViewType.FAB_MESSAGE -> {
                        hide()
                        markReadyForTransition(TreeTransition.Negative)
                    }

                    else -> {}
                }
            }
        }
    }

    override fun positiveChildNode() = ShowAutoApplyProgressNode
    override fun negativeChildNode(): TreeNode {
        val newTotal = inventory?.get<Double>(TreeInventoryType.CART_NEW_TOTAL)
        return if (newTotal != null)
            ApplyBestCouponCodeNode else TerminalNode
    }
}
