package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView
import kotlinx.coroutines.delay

data object WaitBetweenCouponsApplyNode : TreeNode() {

    override suspend fun execute() {
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)

        val delayBetweenCouponMs = config?.delayBetweenCouponMs
        if (config != null && delayBetweenCouponMs != null) {
            delay(delayBetweenCouponMs.toLong())
            markReadyForTransition(TreeTransition.Positive)
        } else {
            inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)?.let {
                waitForWebViewFinishedLoading(it)
            }
            markReadyForTransition(TreeTransition.Positive)
        }
    }

    override fun positiveChildNode(): TreeNode = ClickBeforeStartNode
}
