package app.appnomix.sdk.internal.utils

import android.annotation.SuppressLint
import android.content.Context
import android.location.Address
import android.location.Geocoder
import android.location.Location
import android.location.LocationListener
import android.location.LocationManager
import android.os.Handler
import android.os.Looper
import java.util.Locale

class LocalLocationProvider(private val context: Context) {
    private var address: Address? = null

    fun getAddress(): Address? = address

    fun fetchLocation() {
        val locationManager = context.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        val isGpsEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)
        val isNetworkEnabled =
            locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)
        if (isGpsEnabled || isNetworkEnabled) {
            val providerToUse =
                if (isGpsEnabled) LocationManager.GPS_PROVIDER else LocationManager.NETWORK_PROVIDER
            val locationListener = object : LocationListener {
                override fun onLocationChanged(location: Location) {
                    locationManager.removeUpdates(this)
                    onLocationReceived(context, location)
                }
            }
            Handler(Looper.getMainLooper()).post {
                try {
                    locationManager.requestLocationUpdates(
                        /* provider = */ providerToUse,
                        /* minTimeMs = */ 0,
                        /* minDistanceM = */ 0f,
                        /* listener = */ locationListener
                    )
                } catch (ex: Exception) {
                    SLog.e("Something went wrong while fetching location", ex)
                }
            }
        }
    }

    private fun onLocationReceived(
        context: Context,
        location: Location
    ) {
        val geocoder = Geocoder(context, Locale.getDefault())
        try {
            geocoder.getFromLocation(location.latitude, location.longitude, 1)
                ?.firstOrNull()?.let {
                    address = it
                }
        } catch (ex: Exception) {
            SLog.e("Something went wrong while decoding location", ex)
        }
    }
}
