package app.appnomix.sdk.internal

import android.annotation.SuppressLint
import android.content.Context
import androidx.work.WorkManager
import app.appnomix.sdk.internal.data.SdkConfig
import app.appnomix.sdk.internal.data.network.SaversLeagueApi
import app.appnomix.sdk.internal.domain.CouponsRepo
import app.appnomix.sdk.internal.utils.SLog

@SuppressLint("StaticFieldLeak")
object Deps {
    private lateinit var context: Context
    private val sdkConfig: SdkConfig by lazy {
        SdkConfig(context = context)
    }
    private val repo: CouponsRepo by lazy {
        CouponsRepo(
            context = context,
            sdkConfig = sdkConfig,
            api = api
        )
    }
    private val api: SaversLeagueApi by lazy { SaversLeagueApi() }

    private val workManager by lazy {
        try {
            WorkManager.getInstance(context)
        } catch (e: Exception) {
            SLog.e("WorkManager not available", e)
            null
        }
    }

    fun repo() = repo

    fun api() = api

    fun sdkConfig() = sdkConfig

    fun workManager() = workManager

    fun initialize(context: Context) {
        this.context = context
    }
}