package app.appnomix.sdk.internal.analytics

import app.appnomix.sdk.internal.data.network.model.TimestampWithOffsetSerializer
import kotlinx.serialization.Serializable
import java.time.OffsetDateTime

@Serializable
class AnalyticsEvent private constructor(
    val name: String,
    val category: AnalyticsName.EventCategory,
    @Serializable(TimestampWithOffsetSerializer::class) val timestamp: OffsetDateTime,
    val payload: Map<String, String>
) {
    class Builder(private val eventCategory: AnalyticsName.EventCategory) {
        var name: String = ""
        private var userTimestamp: OffsetDateTime = OffsetDateTime.now()
        private val payload: MutableMap<String, String> = mutableMapOf()

        fun addParam(key: String, value: String): Builder {
            payload[key] = value
            return this
        }

        fun build(): AnalyticsEvent {
            return AnalyticsEvent(
                name = name,
                category = eventCategory,
                timestamp = userTimestamp,
                payload = payload.toMap()
            )
        }
    }
}