package app.appnomix.sdk.internal.analytics

object AnalyticsName {

    enum class EventCategory(val value: String) {
        ONBOARDING(EventCategoryValue.ONBOARDING),
        INSTALL(EventCategoryValue.INSTALL),
        MONETIZATION(EventCategoryValue.MONETIZATION),
        AUTO_APPLY(EventCategoryValue.AUTO_APPLY)
    }

    object EventCategoryValue {
        const val ONBOARDING = "onboarding"
        const val INSTALL = "install"
        const val MONETIZATION = "monetization"
        const val AUTO_APPLY = "auto_apply"
    }

    object EventType {
        // Onboarding
        const val ONBOARDING_GET_STARTED = "get_started"
        const val ONBOARDING_SKIP_FOR_NOW = "skip_for_now"
        const val ONBOARDING_YES_PLEASE = "yes_please"
        const val ONBOARDING_SCREEN_SHOWN = "show"

        // auto apply
        const val CHECKOUT_LOADED = "checkout_loaded"
        const val SHOW_AUTO_APPLY = "show_start"
        const val START_AUTO_APPLY = "start"
        const val CLOSE_AUTO_APPLY = "dismiss_start"
        const val TRY_LATER_AUTO_APPLY = "try_later"
        const val CODE_TRIED_SUCCESS = "code_tried_success"
        const val CODE_TRIED_FAILURE = "code_tried_failure"
        const val STOP_AND_APPLY_SHOW = "stop_and_apply_savings"
        const val STOP_AND_APPLY_KEEP_SEARCHING = "keep_searching"
        const val STOP_AND_APPLY_GO_TO_CHECKOUT = "apply_savings_go_to_cart"
        const val AUTO_APPLY_FINISHED_WITH_SAVINGS = "finished"
        const val CANCEL_APPLYING = "cancel_applying"
        const val CONTINUE_TO_CHECKOUT_FINISH = "continue_to_checkout_finish"
        const val CONTINUE_TO_CHECKOUT_NO_DISCOUNT = "continue_to_checkout_no_discount"
        const val FINISHED_NO_DISCOUNT = "finished_no_discount"


        // MONETIZATION
        const val COPY_CODE_SHOW = "promo_show"
        const val COPY_CODE_ACTION_TAP = "promo_click"
        const val COPY_CODE_CLOSE_TAP = "promo_close"

        // INSTALL
        const val EXTENSION_ACTIVATED = "extension_activated"
    }

    object EventPayloadKey {
        const val CART_VALUE = "cart_value"
        const val USER_ID = "es"
        const val CAMPAIGN_ID = "campaign_id"
        const val PRODUCTION = "production"
        const val APP_VERSION = "app_ver"
        const val SDK_VERSION = "sdk_ver"
        const val OS = "os"

        const val BRAND_NAME = "brand_name"
        const val BRAND_DOMAIN = "brand_domain"
        const val COUPONS_AVAILABLE = "coupons_available"
        const val COUPON_CODE = "code"
        const val SAVINGS = "savings"
        const val CURRENCY = "currency"
        const val COUPONS_TRIED = "coupons_tried"
        const val CART_TOTAL = "cart_total"
    }

}
