package app.appnomix.sdk.internal.data.local

import androidx.room.TypeConverter
import java.time.LocalDateTime
import java.time.ZoneId
import java.time.format.DateTimeFormatter
import java.util.Locale

class Converters {
    private val formatter: DateTimeFormatter = DateTimeFormatter
        .ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS")
        .withLocale(Locale.getDefault())
        .withZone(ZoneId.systemDefault())

    @TypeConverter
    fun fromTimestamp(value: String?): LocalDateTime? {
        if (value == null) return null
        return LocalDateTime.from(formatter.parse(value))
    }

    @TypeConverter
    fun dateToTimestamp(date: LocalDateTime?): String? {
        if (date == null) return null
        return formatter.format(date)
    }

    @TypeConverter
    fun fromStrings(value: String): Set<String> {
        return value.split(",").toSet()
    }

    @TypeConverter
    fun toStrings(strings: Set<String>): String {
        return strings.joinToString(",")
    }
}
