package app.appnomix.sdk.internal.data.local.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import app.appnomix.sdk.internal.data.local.model.CouponWithInteractionEntity
import app.appnomix.sdk.internal.data.local.model.CouponEntity

@Dao
interface CouponDao {

    @Query("SELECT * FROM coupon")
    suspend fun getAll(): List<CouponWithInteractionEntity>

    @Transaction
    suspend fun replace(items: List<CouponWithInteractionEntity>) {
        deleteAllCoupons()
        saveCoupons(items.map { it.couponEntity })
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun saveCoupons(items: List<CouponEntity>)


    @Query("DELETE FROM coupon")
    suspend fun deleteAllCoupons()

    @Query("SELECT * FROM coupon WHERE brand_domain=:brandDomain")
    suspend fun getCoupons(brandDomain: String): List<CouponEntity>
}
