package app.appnomix.sdk.internal.data.local.dao

import androidx.room.Dao
import androidx.room.Query
import java.time.LocalDateTime

@Dao
interface SnoozeDao {

    @Query("UPDATE demand_interaction SET snooze_time=:time, snooze_count=:snoozeCount WHERE brand_domain=:domain")
    suspend fun updateBrandSnoozeTimeAndCount(time: LocalDateTime, snoozeCount: Int, domain: String)

    suspend fun updateBrandSnoozeForDomains(brandDomains: Set<String>, time: LocalDateTime) {
        brandDomains.forEach { updateBrandSnoozeTime(time, it) }
    }

    @Query("UPDATE demand_interaction SET snooze_time=:time WHERE brand_domain=:domain")
    suspend fun updateBrandSnoozeTime(time: LocalDateTime, domain: String)

}
