package app.appnomix.sdk.internal.data.local.model

import androidx.room.ColumnInfo
import androidx.room.Embedded
import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.Relation
import app.appnomix.sdk.internal.domain.model.Demand

data class DemandWithInteractionEntity(
    @Embedded
    val demandEntity: DemandEntity,
    @Relation(
        parentColumn = "root_domain",
        entityColumn = "brand_domain",
    )
    val interactionEntity: DemandInteractionEntity?,
)

@Entity(tableName = "demand")
data class DemandEntity(
    @PrimaryKey @ColumnInfo(name = "root_domain") val rootDomain: String,
    @ColumnInfo(name = "redirect_url") val redirectUrl: String,
    @ColumnInfo(name = "country_code") val countryCode: String?,
)

fun DemandWithInteractionEntity.toDemand(brandImageUrl: String): Demand {
    return Demand(
        redirectUrl = demandEntity.redirectUrl,
        rootDomain = demandEntity.rootDomain,
        countryCode = demandEntity.countryCode,
        lastUseTime = interactionEntity?.lastUseTime,
        snoozeTime = interactionEntity?.snoozeTime,
        snoozeCount = interactionEntity?.snoozeCount ?: 0,
        brandImageUrl = brandImageUrl,
    )
}
