import android.annotation.SuppressLint
import app.appnomix.sdk.internal.data.network.model.CouponDto
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonClassDiscriminator

@SuppressLint("UnsafeOptInUsageError")
@JsonClassDiscriminator("schema_version")
@Serializable
sealed class DomainDataDto {

    @Serializable
    @SerialName("1.0")
    data class DomainDataV1Dto(
        @SerialName("image")
        val image: String? = null,

        @SerialName("root_domain")
        val rootDomain: String? = null,

        @SerialName("brand_name")
        val brandName: String? = null,

        @SerialName("checkout_pages")
        val checkoutPages: List<CheckoutPageDto>? = null,

        @SerialName("promo_codes")
        val coupons: List<CouponDto>? = null,
    ) : DomainDataDto()

    @Serializable
    data object Unknown : DomainDataDto()
}

@SuppressLint("UnsafeOptInUsageError")
@Serializable
data class CheckoutPageDto(
    @SerialName("delay_after_coupon_ms")
    val delayAfterCouponMs: Int? = null,

    @SerialName("delay_between_coupon_ms")
    val delayBetweenCouponMs: Int? = null,

    @SerialName("inserted_at")
    val insertedAt: String? = null,

    @SerialName("path")
    val path: String? = null,

    @SerialName("provider_ref")
    val providerRef: String? = null,

    @SerialName("reload_on_apply")
    val reloadOnApply: Boolean? = null,

    @SerialName("reload_on_remove")
    val reloadOnRemove: Boolean? = null,

    @SerialName("root_domain")
    val rootDomain: String? = null,

    @SerialName("selector_coupon_apply_button")
    val selectorCouponApplyButton: String? = null,

    @SerialName("selector_coupon_error")
    val selectorCouponError: String? = null,

    @SerialName("selector_coupon_input")
    val selectorCouponInput: String? = null,

    @SerialName("selector_coupon_remove_button")
    val selectorCouponRemoveButton: String? = null,

    @SerialName("selector_click_before_start")
    val selectorClickBeforeStart: String? = null,

    @SerialName("selector_coupon_success")
    val selectorCouponSuccess: String? = null,

    @SerialName("selector_order_total_element")
    val selectorOrderTotalElement: String? = null,

    @SerialName("updated_at")
    val updatedAt: String? = null
)
