package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView
import app.appnomix.sdk.internal.domain.machine.states.ApplyCouponCodeNode.evaluateJs
import app.appnomix.sdk.internal.domain.machine.states.ApplyCouponCodeNode.waitForWebViewFinishedLoading
import app.appnomix.sdk.internal.domain.machine.states.TreeNode.JsResult
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewData
import app.appnomix.sdk.internal.utils.SLog

data object ApplyCouponCodeNode : TreeNode() {

    override suspend fun execute() {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (config != null && webView != null) {
            performInMainScope {
                inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)?.apply {
                    val indexBeingVerified =
                        inventory?.get<Int>(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED) ?: 0
                    val couponList =
                        inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST) ?: emptyList()

                    popupViewData?.copy()?.apply {
                        SLog.i("[aa] verifying ${indexBeingVerified + 1} out of ${couponList.size}")
                        set(
                            PopupViewData.PopupViewDataType.CURRENT_COUPON_INDEX_BEING_VALIDATED,
                            indexBeingVerified
                        )
                    }?.let {
                        updateViewData(it)
                    }
                }

                val couponApplyButtonSelector = config.selectorCouponApplyButton ?: ""
                val didExecute = ApplyCouponButtonExecutor.execute(
                    selector = couponApplyButtonSelector,
                    reloadOnApply = config.reloadOnApply == true,
                    webView = webView
                )

                SLog.i("[aa] apply button selection done: $didExecute")
                markReadyForTransition(TreeTransition.Positive)
            }
        }
    }

    override fun positiveChildNode(): TreeNode = WaitForCouponCodeApplyNode
}

object ApplyCouponButtonExecutor {

    suspend fun execute(selector: String, reloadOnApply: Boolean, webView: WebView): Boolean {
        val didTap = evaluateButtonTap(
            webView = webView,
            selector = selector,
        )

        if (reloadOnApply) {
            waitForWebViewFinishedLoading(webView)
        }

        return didTap
    }

    private suspend fun evaluateButtonTap(
        webView: WebView,
        selector: String,
    ): Boolean {
        if (selector.isEmpty()) return false
        val jsCode = """
        (function() {
            var button = document.querySelector(`$selector`);
            if (button) {
                button.click();
                return true;
            }
            return false;
        })();
    """

        val result = evaluateJs<Boolean>(webView, jsCode)
        return if (result is JsResult.Success)
            result.value
        else false
    }
}