package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView

data object ClickBeforeStartNode : TreeNode() {

    override suspend fun execute() {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (config != null && webView != null) {
            val insertInputSelector = config.selectorCouponInput ?: ""
            val insertInputVisible = evaluateSelectorVisibility(
                webView = webView,
                selector = insertInputSelector
            )
            if (insertInputVisible) {
                markReadyForTransition(TreeTransition.Positive)
            } else {
                val clickBeforeInsertSelector = config.selectorClickBeforeStart ?: ""
                val didTap = evaluateButtonTap(
                    webView = webView,
                    selector = clickBeforeInsertSelector,
                )
                if (didTap) {
                    waitForWebViewFinishedLoading(webView)
                }
                markReadyForTransition(TreeTransition.Positive)
            }
        }
    }

    private suspend fun evaluateButtonTap(
        webView: WebView,
        selector: String
    ): Boolean {
        if (selector.isEmpty()) return false
        val jsCode = """
        (function() {
            var button = document.querySelector(`$selector`);
            if (button) {
                button.click();
                return true;
            }
            return false;
        })();
    """

        val result = evaluateJs<Boolean>(webView, jsCode)
        return if (result is JsResult.Success)
            result.value
        else false
    }

    private suspend fun evaluateSelectorVisibility(
        webView: WebView,
        selector: String,
    ): Boolean {
        if (selector.isEmpty()) return false
        val jsCode = """
        (function() {
            var input = document.querySelector(`$selector`);
            if (input) {
                return true;
            }
            return false;
        })();
    """

        val result = evaluateJs<Boolean>(webView, jsCode)
        return if (result is JsResult.Success)
            result.value
        else false
    }

    override fun positiveChildNode(): TreeNode = InsertCouponCodeNode
}
