package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView
import app.appnomix.sdk.internal.utils.SLog

abstract class GetCartTotalNode : TreeNode() {

    suspend fun getCartTotal(): Double? {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val checkoutPageConfig =
            inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (checkoutPageConfig != null && webView != null) {
            val cartTotalSelectors = checkoutPageConfig.selectorOrderTotalElement ?: ""
            waitForWebViewFinishedLoading(webView)
            val cartTotal = evaluateSelector(webView = webView, selector = cartTotalSelectors)

            if (inventory?.contains(TreeInventoryType.CURRENCY_SYMBOL) == false) {
                val currencySymbol =
                    findCurrencySymbol(webView = webView, orderTotalSelector = cartTotalSelectors)
                inventory?.save(TreeInventoryType.CURRENCY_SYMBOL, currencySymbol)
            }
            return cartTotal
        }
        return null
    }

    private suspend fun evaluateSelector(
        webView: WebView,
        selector: String,
    ): Double? {
        if (selector.isEmpty()) return null
        val jsCode = """
        (function() {
            var element = document.querySelector(`$selector`);
            return element ? element.innerText : null;
        })();
    """

        val result = evaluateJs<String>(webView, jsCode)
        return if (result is JsResult.Success) {
            val cleanValue = result.value.replace("[^0-9.]".toRegex(), "").toDoubleOrNull()
            cleanValue
        } else null
    }

    private suspend fun findCurrencySymbol(webView: WebView, orderTotalSelector: String): String? {
        if (orderTotalSelector.isEmpty()) return null
        val jsCode = """
        (function findCurrencySymbol() {
            const currencyRegex = /\b[A-Z][a-zA-Z]{2}\b|[\p{Sc}]/u;
            let element = document.querySelector(`$orderTotalSelector`);
        
            while (element) {
                if (currencyRegex.test(element.textContent)) {
                    return element.textContent.match(currencyRegex)[0];
                }
                element = element.nextElementSibling || element.parentElement;
            }
        
            return null;
        })();
    """

        val result = evaluateJs<String>(webView, jsCode)
        return if (result is JsResult.Success) {
            val cleanValue = result.value.replace("\"", "")
            SLog.d("[aa] currency symbol: $cleanValue")
            cleanValue
        } else null
    }
}
